/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.upgrade.UpdateHandler;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class Main {
    public static void main(String[] args) {
        System.setProperty("java.net.useSystemProxies", "true");
        System.setProperty("http.agent", "HMCL/" + Metadata.VERSION);
        System.setProperty("javafx.autoproxy.disable", "true");
        Main.checkJavaFX();
        Main.checkDirectoryPath();
        Lang.thread(() -> {
            Main.fixLetsEncrypt();
            Main.checkDSTRootCAX3();
        }, "CA Certificate Check", true);
        Logging.start(Metadata.HMCL_DIRECTORY.resolve("logs"));
        if (UpdateHandler.processArguments(args)) {
            return;
        }
        Launcher.main(args);
    }

    private static void checkDirectoryPath() {
        String currentDirectory = new File("").getAbsolutePath();
        if (currentDirectory.contains("!")) {
            Main.showErrorAndExit("Exclamation mark(!) is not allowed in the path where HMCL is in.\nThe path is " + currentDirectory);
        }
    }

    private static void checkJavaFX() {
        try {
            Class.forName("javafx.application.Application");
        }
        catch (ClassNotFoundException e) {
            Main.showErrorAndExit(I18n.i18n("fatal.missing_javafx"));
        }
    }

    private static void checkDSTRootCAX3() {
        TrustManagerFactory tmf;
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            Logging.LOG.log(Level.WARNING, "Failed to init TrustManagerFactory", e);
            return;
        }
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            for (X509Certificate cert : ((X509TrustManager)tm).getAcceptedIssuers()) {
                if (!"CN=DST Root CA X3, O=Digital Signature Trust Co.".equals(cert.getSubjectDN().getName())) continue;
                return;
            }
        }
        Main.showWarningAndContinue(I18n.i18n("fatal.missing_dst_root_ca_x3"));
    }

    static void showErrorAndExit(String message) {
        System.err.println(message);
        System.err.println("A fatal error has occurred, forcibly exiting.");
        JOptionPane.showMessageDialog(null, message, "Error", 0);
        System.exit(1);
    }

    static void showWarningAndContinue(String message) {
        System.err.println(message);
        System.err.println("Potential issues have been detected.");
        JOptionPane.showMessageDialog(null, message, "Warning", 2);
    }

    static void fixLetsEncrypt() {
        try {
            KeyStore defaultKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            Path ksPath = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
            try (InputStream ksStream = Files.newInputStream(ksPath, new OpenOption[0]);){
                defaultKeyStore.load(ksStream, "changeit".toCharArray());
            }
            KeyStore letsEncryptKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream letsEncryptFile = Main.class.getResourceAsStream("/assets/lekeystore.jks");
            letsEncryptKeyStore.load(letsEncryptFile, "supersecretpassword".toCharArray());
            KeyStore merged = KeyStore.getInstance(KeyStore.getDefaultType());
            merged.load(null, new char[0]);
            for (String alias : Collections.list(letsEncryptKeyStore.aliases())) {
                merged.setCertificateEntry(alias, letsEncryptKeyStore.getCertificate(alias));
            }
            for (String alias : Collections.list(defaultKeyStore.aliases())) {
                merged.setCertificateEntry(alias, defaultKeyStore.getCertificate(alias));
            }
            TrustManagerFactory instance = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            instance.init(merged);
            SSLContext tls = SSLContext.getInstance("TLS");
            tls.init(null, instance.getTrustManagers(), null);
            HttpsURLConnection.setDefaultSSLSocketFactory(tls.getSocketFactory());
            Logging.LOG.info("Added Lets Encrypt root certificates as additional trust");
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Logging.LOG.log(Level.SEVERE, "Failed to load lets encrypt certificate. Expect problems", e);
        }
    }
}

