/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import org.jackhuang.hmcl.Main;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.task.AsyncTaskExecutor;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.upgrade.UpdateChecker;
import org.jackhuang.hmcl.util.CrashReporter;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class Launcher
extends Application {
    public static final CookieManager COOKIE_MANAGER = new CookieManager();
    public static final CrashReporter CRASH_REPORTER = new CrashReporter(true);

    public void start(Stage primaryStage) {
        Thread.currentThread().setUncaughtExceptionHandler(CRASH_REPORTER);
        CookieHandler.setDefault(COOKIE_MANAGER);
        try {
            try {
                ConfigHolder.init();
            }
            catch (IOException e) {
                Logging.LOG.log(Level.SEVERE, "Failed to load config", e);
                Main.showErrorAndExit(I18n.i18n("fatal.config_loading_failure", Paths.get("", new String[0]).toAbsolutePath().normalize()));
            }
            Platform.runLater(() -> {
                Platform.setImplicitExit((boolean)false);
                Controllers.initialize(primaryStage);
                UpdateChecker.init();
                primaryStage.show();
            });
        }
        catch (Throwable e) {
            CRASH_REPORTER.uncaughtException(Thread.currentThread(), e);
        }
    }

    public void stop() throws Exception {
        super.stop();
        Controllers.onApplicationStop();
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(CRASH_REPORTER);
        AsyncTaskExecutor.setUncaughtExceptionHandler(new CrashReporter(false));
        try {
            Logging.LOG.info("*** " + Metadata.TITLE + " ***");
            Logging.LOG.info("Operating System: " + System.getProperty("os.name") + ' ' + OperatingSystem.SYSTEM_VERSION);
            Logging.LOG.info("Java Version: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
            Logging.LOG.info("Java VM Version: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor"));
            Logging.LOG.info("Java Home: " + System.getProperty("java.home"));
            Logging.LOG.info("Current Directory: " + Paths.get("", new String[0]).toAbsolutePath());
            Logging.LOG.info("HMCL Directory: " + Metadata.HMCL_DIRECTORY);
            Logging.LOG.info("Memory: " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "MB");
            ManagementFactory.getMemoryPoolMXBeans().stream().filter(bean -> bean.getName().equals("Metaspace")).findAny().ifPresent(bean -> Logging.LOG.info("Metaspace: " + bean.getUsage().getUsed() / 1024L / 1024L + "MB"));
            Launcher.launch((String[])args);
        }
        catch (Throwable e) {
            CRASH_REPORTER.uncaughtException(Thread.currentThread(), e);
        }
    }

    public static void stopApplication() {
        Logging.LOG.info("Stopping application.\n" + StringUtils.getStackTrace(Thread.currentThread().getStackTrace()));
        FXUtils.runInFX(() -> {
            if (Controllers.getStage() == null) {
                return;
            }
            Controllers.getStage().close();
            Schedulers.shutdown();
            Controllers.shutdown();
            Platform.exit();
        });
    }

    public static void stopWithoutPlatform() {
        Logging.LOG.info("Stopping application without JavaFX Toolkit.\n" + StringUtils.getStackTrace(Thread.currentThread().getStackTrace()));
        FXUtils.runInFX(() -> {
            if (Controllers.getStage() == null) {
                return;
            }
            Controllers.getStage().close();
            Schedulers.shutdown();
            Controllers.shutdown();
            Lang.executeDelayed(OperatingSystem::forceGC, TimeUnit.SECONDS, 5L, true);
        });
    }

    public static List<File> getCurrentJarFiles() {
        LinkedList<File> result = new LinkedList<File>();
        if (Launcher.class.getClassLoader() instanceof URLClassLoader) {
            URL[] urls;
            for (URL u : urls = ((URLClassLoader)Launcher.class.getClassLoader()).getURLs()) {
                try {
                    File f = new File(u.toURI());
                    if (!f.isFile() || !f.getName().endsWith(".exe") && !f.getName().endsWith(".jar")) continue;
                    result.add(f);
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }
}

