/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.fxgson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import org.hildan.fxgson.creators.ObservableListCreator;
import org.hildan.fxgson.creators.ObservableMapCreator;
import org.hildan.fxgson.creators.ObservableSetCreator;
import org.hildan.fxgson.factories.JavaFxExtraTypeAdapterFactory;
import org.hildan.fxgson.factories.JavaFxPropertyTypeAdapterFactory;

public class FxGsonBuilder {
    private final GsonBuilder builder;
    private boolean strictProperties = true;
    private boolean strictPrimitives = true;
    private boolean includeExtras = false;

    public FxGsonBuilder() {
        this(new GsonBuilder());
    }

    public FxGsonBuilder(GsonBuilder sourceBuilder) {
        this.builder = sourceBuilder;
    }

    public GsonBuilder builder() {
        this.builder.serializeNulls().registerTypeAdapter((Type)((Object)ObservableList.class), new ObservableListCreator()).registerTypeAdapter((Type)((Object)ObservableSet.class), new ObservableSetCreator()).registerTypeAdapter((Type)((Object)ObservableMap.class), new ObservableMapCreator()).registerTypeAdapterFactory(new JavaFxPropertyTypeAdapterFactory(this.strictProperties, this.strictPrimitives));
        if (this.includeExtras) {
            this.builder.registerTypeAdapterFactory(new JavaFxExtraTypeAdapterFactory());
        }
        return this.builder;
    }

    public Gson create() {
        return this.builder().create();
    }

    public FxGsonBuilder acceptNullProperties() {
        this.strictProperties = false;
        return this;
    }

    public FxGsonBuilder acceptNullPrimitives() {
        this.strictPrimitives = false;
        return this;
    }

    public FxGsonBuilder withExtras() {
        this.includeExtras = true;
        return this;
    }
}

