/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.adapters;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import sun.misc.Unsafe;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ReflectionHelper {
    private static Unsafe unsafe = null;
    private static long objectFieldOffset;

    private static void setAccessible(AccessibleObject accessibleObject) {
        unsafe.putBoolean(accessibleObject, objectFieldOffset, true);
    }

    public static <T> T invoke(Class clazz, Object object, String string) {
        try {
            Method method = clazz.getDeclaredMethod(string, new Class[0]);
            ReflectionHelper.setAccessible(method);
            return (T)method.invoke(object, new Object[0]);
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    public static <T> T invoke(Object object, String string) {
        return ReflectionHelper.invoke(object.getClass(), object, string);
    }

    public static VarHandle getHandle(Class<?> clazz, String string, Class<?> clazz2) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(clazz, MethodHandles.lookup());
            return lookup.findVarHandle(clazz, string, clazz2);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return null;
        }
    }

    public static Field getField(Class clazz, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            ReflectionHelper.setAccessible(field);
            return field;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static <T> T getFieldContent(Object object, String string) {
        return ReflectionHelper.getFieldContent(object.getClass(), object, string);
    }

    public static <T> T getFieldContent(Class clazz, Object object, String string) {
        try {
            Field field = clazz.getDeclaredField(string);
            ReflectionHelper.setAccessible(field);
            return (T)field.get(object);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void setFieldContent(Class clazz, Object object, String string, Object object2) {
        try {
            Field field = clazz.getDeclaredField(string);
            ReflectionHelper.setAccessible(field);
            field.set(object, object2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setFieldContent(Class clazz, Object object, String string, Object object2, Class clazz2) {
        try {
            ReflectionHelper.getHandle(clazz, string, clazz2).set(object, object2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        try {
            unsafe = (Unsafe)AccessController.doPrivileged(() -> {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            });
            Field field = AccessibleObject.class.getDeclaredField("override");
            objectFieldOffset = unsafe.objectFieldOffset(field);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

