/*
 * Decompiled with CFR 0.152.
 */
package com.pdos95.pinyin;

import codechicken.nei.NEIClientConfig;
import com.hp.hpl.sparta.Document;
import com.hp.hpl.sparta.Element;
import com.hp.hpl.sparta.ParseException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinUtils {
    public static final int HAS_FIRST_PINYIN = 1;
    public static final int HAS_ALL_PINYIN = 2;
    public static final List<String> sPinyinChars = new ArrayList<String>();
    public static final HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();

    private static Document getPinyinMappingDoc() {
        Document doc = null;
        try {
            Class<?> resClass = Class.forName("net.sourceforge.pinyin4j.PinyinRomanizationResource");
            Method getInstanceMethod = resClass.getDeclaredMethod("getInstance", new Class[0]);
            getInstanceMethod.setAccessible(true);
            Object res = getInstanceMethod.invoke(null, new Object[0]);
            getInstanceMethod.setAccessible(false);
            Method getPinyinMappingDocMethod = resClass.getDeclaredMethod("getPinyinMappingDoc", new Class[0]);
            getPinyinMappingDocMethod.setAccessible(true);
            doc = (Document)getPinyinMappingDocMethod.invoke(res, new Object[0]);
            getPinyinMappingDocMethod.setAccessible(true);
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Load pinyin alphabet fail!", (Throwable)e);
        }
        return doc;
    }

    private static String formatHanyuPinyin(String pinyinStr, HanyuPinyinOutputFormat outputFormat) {
        String formatStr = null;
        try {
            Class<?> resClass = Class.forName("net.sourceforge.pinyin4j.PinyinFormatter");
            Method getInstanceMethod = resClass.getDeclaredMethod("formatHanyuPinyin", String.class, HanyuPinyinOutputFormat.class);
            getInstanceMethod.setAccessible(true);
            formatStr = (String)getInstanceMethod.invoke(null, pinyinStr, outputFormat);
            getInstanceMethod.setAccessible(false);
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Format pinyin fail!", (Throwable)e);
        }
        return formatStr;
    }

    private static void initPinyinCharList() {
        Document doc = PinyinUtils.getPinyinMappingDoc();
        try {
            Enumeration e = doc.xpathSelectElements("//Hanyu");
            while (e.hasMoreElements()) {
                sPinyinChars.add(PinyinUtils.formatHanyuPinyin(((Element)e.nextElement()).toString(), format));
            }
        }
        catch (ParseException e) {
            NEIClientConfig.logger.error("Parse pinyin alphabet fail!", (Throwable)e);
        }
    }

    public static ArrayList<ArrayList<String>> getPinyinCharList(String displayName, boolean isMatch) {
        char[] nameChars;
        if (displayName == null || "".equals(displayName)) {
            return null;
        }
        ArrayList<ArrayList<String>> pinyinCharList = new ArrayList<ArrayList<String>>(displayName.length());
        for (char oneChar : nameChars = displayName.toCharArray()) {
            String[] pinyins;
            try {
                pinyins = PinyinHelper.toHanyuPinyinStringArray(oneChar, format);
            }
            catch (BadHanyuPinyinOutputFormatCombination e) {
                continue;
            }
            ArrayList<String> pinyinChars = new ArrayList<String>(pinyins == null ? 1 : pinyins.length);
            if (pinyins == null) {
                pinyinChars.add("" + oneChar);
            } else {
                for (String pinyin : pinyins) {
                    if (isMatch) {
                        pinyinChars.add(pinyin + ',');
                        continue;
                    }
                    pinyinChars.add(pinyin);
                }
            }
            pinyinCharList.add(pinyinChars);
        }
        if (pinyinCharList.isEmpty()) {
            return null;
        }
        return pinyinCharList;
    }

    public static String getHanyuPinyinDebugInfo(String displayName) {
        if (displayName == null || "".equals(displayName)) {
            return "";
        }
        StringBuffer pinyinInfo = new StringBuffer();
        ArrayList<ArrayList<String>> pinyinCharList = PinyinUtils.getPinyinCharList(displayName, false);
        for (ArrayList<String> arrayList : pinyinCharList) {
            if (arrayList.size() == 1) {
                pinyinInfo.append(arrayList.get(0));
                continue;
            }
            pinyinInfo.append(arrayList.toString());
        }
        return pinyinInfo.toString();
    }

    public static String getHanyuPinyinMatchStr(String displayName) {
        if (displayName == null || "".equals(displayName)) {
            return "";
        }
        StringBuffer pinyinInfo = new StringBuffer();
        ArrayList<ArrayList<String>> pinyinCharList = PinyinUtils.getPinyinCharList(displayName, true);
        for (ArrayList<String> arrayList : pinyinCharList) {
            if (arrayList.get(0).endsWith(",")) {
                pinyinInfo.append("'[");
                for (int i = 0; i < arrayList.size(); ++i) {
                    pinyinInfo.append(arrayList.get(i));
                }
                pinyinInfo.append("]");
                continue;
            }
            pinyinInfo.append(arrayList.get(0));
        }
        return pinyinInfo.toString();
    }

    public static String getHanyuPinyinDisplayName(String displayName, int mode) {
        if (displayName == null || "".equals(displayName)) {
            return "";
        }
        ArrayList pinyinCharList = new ArrayList();
        ArrayList<ArrayList<String>> cachePinyinCharList = PinyinUtils.getPinyinCharList(displayName, false);
        for (ArrayList<String> cachePinyinChars : cachePinyinCharList) {
            HashSet<String> pinyinChars = new HashSet<String>();
            for (String pinyinChar : cachePinyinChars) {
                if ((mode & 1) > 0) {
                    pinyinChars.add("" + pinyinChar.charAt(0));
                }
                if ((mode & 2) <= 0) continue;
                pinyinChars.add(pinyinChar);
            }
            pinyinCharList.add(new ArrayList(pinyinChars));
        }
        if (pinyinCharList.isEmpty()) {
            return "";
        }
        LinkedList<StringBuffer> pinyinBufferList = new LinkedList<StringBuffer>();
        int[] pinyinBufferIndex = new int[displayName.length()];
        block2: while (true) {
            int index;
            int i;
            StringBuffer pinyinBuffer = new StringBuffer("!");
            for (i = 0; i < pinyinBufferIndex.length; ++i) {
                index = pinyinBufferIndex[i];
                String onechar = (String)((ArrayList)pinyinCharList.get(i)).get(index);
                pinyinBuffer.append(onechar);
            }
            pinyinBufferList.add(pinyinBuffer);
            for (i = pinyinBufferIndex.length - 1; i >= 0; --i) {
                index = pinyinBufferIndex[i];
                if (index == ((ArrayList)pinyinCharList.get(i)).size() - 1) continue;
                int n = i;
                pinyinBufferIndex[n] = pinyinBufferIndex[n] + 1;
                int o = i + 1;
                while (true) {
                    if (o >= pinyinBufferIndex.length) continue block2;
                    pinyinBufferIndex[o] = 0;
                    ++o;
                }
            }
            break;
        }
        StringBuffer pinyinKey = new StringBuffer();
        for (StringBuffer pinyin : pinyinBufferList) {
            pinyinKey.append(pinyin);
            pinyinKey.append(',');
        }
        return pinyinKey.substring(0, pinyinKey.length() - 1);
    }

    static {
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setVCharType(HanyuPinyinVCharType.WITH_V);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        PinyinUtils.initPinyinCharList();
    }
}

