/*
 * Decompiled with CFR 0.152.
 */
package com.pdos95.gui;

import codechicken.nei.ItemStackSet;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.SubsetWidget;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SubsetTag {
    public static boolean[] statesSaved = new boolean[7];

    public static void loadStates() {
        for (int state = 0; state < 7; ++state) {
            SubsetTag.statesSaved[state] = !NEIClientConfig.global.nbt.func_74775_l("subsettagSave" + state).func_82582_d();
        }
    }

    public static void clearState(int state) {
        SubsetTag.statesSaved[state] = false;
        NEIClientConfig.global.nbt.func_74782_a("subsettagSave" + state, (NBTBase)new NBTTagCompound());
        NEIClientConfig.global.saveNBT();
    }

    public static void loadState(int state) {
        if (!statesSaved[state]) {
            return;
        }
        NBTTagCompound statesave = NEIClientConfig.global.nbt.func_74775_l("subsettagSave" + state);
        ItemStackSet hiddenItems = new ItemStackSet();
        if (statesave.func_74764_b("hiddenItems")) {
            NBTTagList areaTag = statesave.func_150295_c("hiddenItems", 10);
            for (int i = 0; i < areaTag.func_74745_c(); ++i) {
                NBTTagCompound stacksave = areaTag.func_150305_b(i);
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)stacksave);
                hiddenItems.add(stack);
            }
        }
        SubsetTag.setHiddenItems(hiddenItems);
        String matchStr = "";
        if (statesave.func_74764_b("matchStr")) {
            matchStr = statesave.func_74779_i("matchStr");
        }
        SubsetTag.setNEIMatchStr(matchStr);
        SubsetTag.reflashHiddenItems();
    }

    public static void saveState(int state) {
        String matchStr;
        NBTTagCompound statesave = NEIClientConfig.global.nbt.func_74775_l("subsettagSave" + state);
        ItemStackSet hiddenItems = SubsetTag.getHiddenItems();
        if (hiddenItems != null) {
            NBTTagList areaTag = new NBTTagList();
            List hiddenItemsList = hiddenItems.values();
            for (int i = 0; i < hiddenItemsList.size(); ++i) {
                ItemStack stack = (ItemStack)hiddenItemsList.get(i);
                if (stack == null) continue;
                NBTTagCompound stacksave = new NBTTagCompound();
                stack.func_77955_b(stacksave);
                areaTag.func_74742_a((NBTBase)stacksave);
            }
            statesave.func_74782_a("hiddenItems", (NBTBase)areaTag);
        }
        if ((matchStr = SubsetTag.getNEIMatchStr()) == null) {
            matchStr = "";
        }
        statesave.func_74778_a("matchStr", matchStr);
        NEIClientConfig.global.nbt.func_74782_a("subsettagSave" + state, (NBTBase)statesave);
        NEIClientConfig.global.saveNBT();
        SubsetTag.statesSaved[state] = true;
    }

    private static void reflashHiddenItems() {
        try {
            Class<SubsetWidget> c = SubsetWidget.class;
            Method updateHiddenItemsMethod = c.getDeclaredMethod("updateHiddenItems", new Class[0]);
            updateHiddenItemsMethod.setAccessible(true);
            updateHiddenItemsMethod.invoke(null, new Object[0]);
            updateHiddenItemsMethod.setAccessible(false);
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("reflash hidden items fail!", (Throwable)e);
            return;
        }
    }

    private static ItemStackSet getHiddenItems() {
        ItemStackSet hiddenItems = null;
        try {
            Class<SubsetWidget> c = SubsetWidget.class;
            Field hiddenItemsField = c.getDeclaredField("hiddenItems");
            hiddenItemsField.setAccessible(true);
            hiddenItems = (ItemStackSet)hiddenItemsField.get(null);
            hiddenItemsField.setAccessible(false);
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Read hidden items fail!", (Throwable)e);
        }
        return hiddenItems;
    }

    private static void setHiddenItems(ItemStackSet newHiddenItems) {
        ItemStackSet hiddenItems = SubsetTag.getHiddenItems();
        if (hiddenItems == null) {
            return;
        }
        hiddenItems.clear();
        for (ItemStack item : newHiddenItems.values()) {
            hiddenItems.add(item);
        }
    }

    public static String getNEIMatchStr() {
        String neiMatchStr = null;
        try {
            Class c = ReflectionHelper.getClass((ClassLoader)SubsetTag.class.getClassLoader(), (String[])new String[]{"codechicken.nei.LayoutManager"});
            Field fldSearchField = c.getField("searchField");
            Object searchField = fldSearchField.get(c);
            Method a = searchField.getClass().getMethod("text", new Class[0]);
            neiMatchStr = (String)a.invoke(searchField, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (neiMatchStr == null || "".equals(neiMatchStr)) {
            return null;
        }
        return neiMatchStr;
    }

    public static void setNEIMatchStr(String filter) {
        try {
            Class c = ReflectionHelper.getClass((ClassLoader)SubsetTag.class.getClassLoader(), (String[])new String[]{"codechicken.nei.LayoutManager"});
            Field fldSearchField = c.getField("searchField");
            Object searchField = fldSearchField.get(c);
            Method a = searchField.getClass().getMethod("setText", String.class);
            Method b = searchField.getClass().getMethod("onTextChange", String.class);
            a.invoke(searchField, filter);
            b.invoke(searchField, "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        SubsetTag.loadStates();
    }
}

