/*
 * Decompiled with CFR 0.152.
 */
package com.pdos95.gui;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.ItemPanel;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.config.ConfigSet;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import com.pdos95.NEISasySearchConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.lwjgl.input.Keyboard;

public class MyItemPanel
extends ItemPanel
implements IUsageHandler,
ICraftingHandler,
IContainerInputHandler {
    public static final int MAS_HISTORYS = 60;
    public static final int MAS_FAVORITES = 30;
    public static final int USE_ROWS = 3;
    public static ConfigSet world;
    public ArrayList<ItemStack> historys = new ArrayList();
    public ArrayList<ItemStack> favorites = new ArrayList();
    public int h;
    int rows;
    int columns;
    int start;
    private boolean[] validSlotMap;

    public void resize() {
        if (!NEISasySearchConfig.isSwitch() || !NEISasySearchConfig.enableItemPanel()) {
            super.resize();
            return;
        }
        this.h = ((ItemPanel)this).h;
        ((ItemPanel)this).h -= 54;
        super.resize();
        this.rows = this.getRows();
        this.columns = this.getColumns();
        this.start = this.rows * this.columns;
        this.updateValidSlots();
        if (world != NEIClientConfig.world) {
            this.loadFavorites();
            world = NEIClientConfig.world;
            this.historys.clear();
        }
    }

    public int getRows() {
        int rows = this.h / 18;
        try {
            Field field = ItemPanel.class.getDeclaredField("rows");
            field.setAccessible(true);
            rows = field.getInt((Object)this);
            field.setAccessible(false);
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Get ItemPanel rows fail!", (Throwable)e);
        }
        return rows;
    }

    public int getColumns() {
        int columns = this.w / 18;
        try {
            Field field = ItemPanel.class.getDeclaredField("columns");
            field.setAccessible(true);
            columns = field.getInt((Object)this);
            field.setAccessible(false);
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Get ItemPanel columns fail!", (Throwable)e);
        }
        return columns;
    }

    public void draw(int mousex, int mousey) {
        Rectangle4i rect;
        int i;
        super.draw(mousex, mousey);
        if (!NEISasySearchConfig.isSwitch() || !NEISasySearchConfig.enableItemPanel()) {
            return;
        }
        GuiContainerManager.enableMatrixStackLogging();
        Rectangle4i firstRect = this.getSlotRect(this.start);
        GuiDraw.drawRect((int)firstRect.x, (int)firstRect.y, (int)(this.columns * firstRect.w), (int)(2 * firstRect.h), (int)0x44FFFFFF);
        GuiDraw.drawRect((int)firstRect.x, (int)(2 * firstRect.h + firstRect.y), (int)(this.columns * firstRect.w), (int)firstRect.h, (int)0x66FFFFFF);
        int startAdd = 0;
        for (i = 0; i < this.columns * 2 && i < this.historys.size(); ++i) {
            if (!this.validSlotMap[i + startAdd]) continue;
            rect = this.getSlotRect(this.start + startAdd + i);
            if (rect.contains(mousex, mousey)) {
                GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-296397483);
            }
            GuiContainerManager.drawItem((int)(rect.x + 1), (int)(rect.y + 1), (ItemStack)this.historys.get(i));
        }
        startAdd += this.columns * 2;
        for (i = 0; i < this.columns && i < this.favorites.size(); ++i) {
            if (!this.validSlotMap[i + startAdd]) continue;
            rect = this.getSlotRect(this.start + startAdd + i);
            if (rect.contains(mousex, mousey)) {
                GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-296397483);
            }
            GuiContainerManager.drawItem((int)(rect.x + 1), (int)(rect.y + 1), (ItemStack)this.favorites.get(i));
        }
        GuiContainerManager.disableMatrixStackLogging();
    }

    private void updateValidSlots() {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        this.validSlotMap = new boolean[this.columns * 3];
        for (int i = 0; i < this.validSlotMap.length; ++i) {
            if (!this.slotValid(gui, i)) continue;
            this.validSlotMap[i] = true;
        }
    }

    private boolean slotValid(GuiContainer gui, int i) {
        Rectangle4i rect = this.getSlotRect(this.start + i);
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            if (!handler.hideItemPanelSlot(gui, rect.x, rect.y, rect.w, rect.h)) continue;
            return false;
        }
        return true;
    }

    private void addHistorys(ItemStack stack) {
        stack.field_77994_a = 1;
        for (int i = this.historys.size() - 1; i >= 0; --i) {
            if (!stack.func_77969_a(this.historys.get(i))) continue;
            this.historys.remove(i);
        }
        this.historys.add(0, stack);
        while (this.historys.size() > 60) {
            this.historys.remove(59);
        }
    }

    private void addFavorites(ItemStack stack) {
        stack.field_77994_a = 1;
        for (int i = this.favorites.size() - 1; i >= 0; --i) {
            if (!stack.func_77969_a(this.favorites.get(i))) continue;
            return;
        }
        this.favorites.add(stack);
        while (this.favorites.size() > 30) {
            this.favorites.remove(29);
        }
        this.saveFavorites();
    }

    private void delFavorites(ItemStack stack) {
        for (int i = this.favorites.size() - 1; i >= 0; --i) {
            if (!stack.func_77969_a(this.favorites.get(i))) continue;
            this.favorites.remove(i);
        }
        this.saveFavorites();
    }

    private void loadFavorites() {
        this.favorites.clear();
        NBTTagCompound statesave = NEIClientConfig.world.nbt.func_74775_l("itemsfavorites");
        if (statesave.func_74764_b("items")) {
            NBTTagList areaTag = statesave.func_150295_c("items", 10);
            for (int i = 0; i < areaTag.func_74745_c(); ++i) {
                NBTTagCompound stacksave = areaTag.func_150305_b(i);
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)stacksave);
                this.favorites.add(stack);
            }
        }
    }

    private void saveFavorites() {
        NBTTagCompound statesave = NEIClientConfig.world.nbt.func_74775_l("itemsfavorites");
        NBTTagList areaTag = new NBTTagList();
        for (int i = 0; i < this.favorites.size(); ++i) {
            ItemStack stack = this.favorites.get(i);
            if (stack == null) continue;
            NBTTagCompound stacksave = new NBTTagCompound();
            stack.func_77955_b(stacksave);
            areaTag.func_74742_a((NBTBase)stacksave);
        }
        statesave.func_74782_a("items", (NBTBase)areaTag);
        NEIClientConfig.world.nbt.func_74782_a("itemsfavorites", (NBTBase)statesave);
        NEIClientConfig.world.saveNBT();
    }

    public void mouseUp(int mousex, int mousey, int button) {
        super.mouseUp(mousex, mousey, button);
        Rectangle4i firstRect = this.getSlotRect(this.start);
        firstRect.w = this.columns * firstRect.w;
        firstRect.h = 3 * firstRect.h;
        if (!firstRect.contains(mousex, mousey)) {
            return;
        }
        ItemStack stack = this.getStackMouseOver(mousex, mousey);
        if (stack == null) {
            return;
        }
        if (NEIController.manager.window instanceof GuiRecipe || !NEIClientConfig.canCheatItem((ItemStack)stack)) {
            if (button == 0) {
                GuiCraftingRecipe.openRecipeGui((String)"item", (Object[])new Object[]{stack});
            } else if (button == 1) {
                GuiUsageRecipe.openRecipeGui((String)"item", (Object[])new Object[]{stack});
            }
            this.draggedStack = null;
            this.mouseDownSlot = -1;
            return;
        }
        NEIClientUtils.cheatItem((ItemStack)stack, (int)button, (int)-1);
    }

    public boolean handleClick(int mousex, int mousey, int button) {
        boolean returnValue = super.handleClick(mousex, mousey, button);
        if (!returnValue) {
            Rectangle4i firstRect = this.getSlotRect(this.start);
            firstRect.w = this.columns * firstRect.w;
            firstRect.h = 3 * firstRect.h;
            if (firstRect.contains(mousex, mousey)) {
                return true;
            }
        }
        return returnValue;
    }

    public ItemStack getStackMouseOver(int mousex, int mousey) {
        int i;
        ItemStack stack = super.getStackMouseOver(mousex, mousey);
        if (stack != null) {
            return stack;
        }
        if (!NEISasySearchConfig.isSwitch() || !NEISasySearchConfig.enableItemPanel()) {
            return null;
        }
        int startAdd = 0;
        for (i = 0; i < this.columns * 2 && i < this.historys.size(); ++i) {
            if (!this.validSlotMap[i + startAdd] || !this.getSlotRect(this.start + startAdd + i).contains(mousex, mousey)) continue;
            return this.historys.get(i);
        }
        startAdd += this.columns * 2;
        for (i = 0; i < this.columns && i < this.favorites.size(); ++i) {
            if (!this.validSlotMap[i + startAdd] || !this.getSlotRect(this.start + startAdd + i).contains(mousex, mousey)) continue;
            return this.favorites.get(i);
        }
        return null;
    }

    public boolean contains(int px, int py) {
        boolean returnValue = super.contains(px, py);
        if (!returnValue) {
            try {
                Rectangle4i firstRect = this.getSlotRect(this.start);
                firstRect.w = this.columns * firstRect.w;
                firstRect.h = 3 * firstRect.h;
                if (firstRect.contains(px, py)) {
                    return true;
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public String getRecipeName() {
        return "easysearch";
    }

    public int numRecipes() {
        return 0;
    }

    public void drawBackground(int recipe) {
    }

    public void drawForeground(int recipe) {
    }

    public List<PositionedStack> getIngredientStacks(int recipe) {
        return new ArrayList<PositionedStack>();
    }

    public List<PositionedStack> getOtherStacks(int recipetype) {
        return new ArrayList<PositionedStack>();
    }

    public PositionedStack getResultStack(int recipe) {
        return null;
    }

    public void onUpdate() {
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        return null;
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        return null;
    }

    public int recipiesPerPage() {
        return 0;
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        return currenttip;
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        return currenttip;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        return false;
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        return false;
    }

    public ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        if (!NEISasySearchConfig.isSwitch() || !NEISasySearchConfig.enableItemPanel()) {
            return this;
        }
        if (results.length > 0 && results[0] instanceof ItemStack) {
            this.addHistorys((ItemStack)results[0]);
        }
        return this;
    }

    public IUsageHandler getUsageHandler(String inputId, Object ... ingredients) {
        if (!NEISasySearchConfig.isSwitch() || !NEISasySearchConfig.enableItemPanel()) {
            return this;
        }
        if (ingredients.length > 0 && ingredients[0] instanceof ItemStack) {
            this.addHistorys((ItemStack)ingredients[0]);
        }
        return this;
    }

    public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
        return false;
    }

    public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
    }

    public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyCode) {
        if (!NEISasySearchConfig.isSwitch() || !NEISasySearchConfig.enableItemPanel()) {
            return false;
        }
        ItemStack stackover = GuiContainerManager.getStackMouseOver((GuiContainer)gui);
        if (stackover == null) {
            return false;
        }
        if (Keyboard.isKeyDown((int)NEIClientConfig.getKeyBinding((String)NEISasySearchConfig.KEY_SEARCH_FAVORITE))) {
            if (Keyboard.isKeyDown((int)NEIClientConfig.getKeyBinding((String)NEISasySearchConfig.KEY_SEARCH_SUPER))) {
                this.delFavorites(stackover);
            } else {
                this.addFavorites(stackover);
            }
            return true;
        }
        return false;
    }

    public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        return false;
    }

    public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
    }

    public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
    }

    public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        return false;
    }

    public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
    }

    public void onMouseDragged(GuiContainer gui, int mousex, int mousey, int button, long heldTime) {
    }
}

