/*
 * Decompiled with CFR 0.152.
 */
package com.pdos95;

import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.SearchField;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.api.ItemInfo;
import com.pdos95.NEISasySearchConfig;
import com.pdos95.gui.SubsetTag;
import com.pdos95.pinyin.PinyinUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;

public class PinyinSearchProvider
implements SearchField.ISearchProvider,
ItemList.ItemsLoadedCallback {
    public static final HashMap<ItemStack, String> itemSearchNames = new HashMap();
    public static final PinyinCharList rootPinyinChar = new PinyinCharList();

    public void itemsLoaded() {
        itemSearchNames.clear();
    }

    public boolean isPrimary() {
        return true;
    }

    private static List<PinyinCharInfo> parserSearchText(String searchText) {
        if (searchText == null || "".equals(searchText)) {
            return null;
        }
        ArrayList<PinyinCharInfo> pinyinCharInfoList = new ArrayList<PinyinCharInfo>();
        ArrayList<Stack<Integer>> tryEndList = new ArrayList<Stack<Integer>>();
        int parsedOffset = 0;
        int start = 0;
        boolean init = true;
        block0: while (true) {
            if (searchText.length() == start) break;
            if (!init && tryEndList.isEmpty()) {
                return null;
            }
            PinyinCharInfo pinyinCharInfo = new PinyinCharInfo();
            if (searchText.charAt(start) == '\'') {
                PinyinSearchProvider.applyToPinyinCharInfo(searchText, tryEndList, pinyinCharInfoList, parsedOffset);
                tryEndList.clear();
                init = true;
                parsedOffset = ++start;
            }
            List<Integer> endList = PinyinSearchProvider.parserSearchItem(searchText, start, pinyinCharInfo);
            init = false;
            if (pinyinCharInfo.type == 1) {
                PinyinSearchProvider.applyToPinyinCharInfo(searchText, tryEndList, pinyinCharInfoList, parsedOffset);
                tryEndList.clear();
                init = true;
                pinyinCharInfoList.add(pinyinCharInfo);
                parsedOffset = start = endList.get(0).intValue();
                continue;
            }
            if (endList == null) {
                int i = tryEndList.size() - 1;
                while (true) {
                    if (i < 0) continue block0;
                    Stack endStack = (Stack)tryEndList.get(i);
                    if (endStack.size() != 1) {
                        endStack.pop();
                        start = (Integer)endStack.peek();
                        continue block0;
                    }
                    endStack.clear();
                    tryEndList.remove(i);
                    --i;
                }
            }
            Stack<Integer> endStack = new Stack<Integer>();
            for (int i = 0; i < endList.size(); ++i) {
                endStack.push(endList.get(i));
            }
            start = (Integer)endStack.peek();
            tryEndList.add(endStack);
        }
        parsedOffset = PinyinSearchProvider.applyToPinyinCharInfo(searchText, tryEndList, pinyinCharInfoList, parsedOffset);
        return pinyinCharInfoList;
    }

    private static int applyToPinyinCharInfo(String searchText, List<Stack<Integer>> tryEndList, List<PinyinCharInfo> pinyinCharInfoList, int parsedOffset) {
        int lastEnd = parsedOffset;
        for (int i = 0; i < tryEndList.size(); ++i) {
            Stack<Integer> endStack = tryEndList.get(i);
            int end = endStack.peek();
            endStack.clear();
            PinyinCharInfo pinyinCharInfo = new PinyinCharInfo();
            pinyinCharInfo.str = searchText.substring(lastEnd, end);
            pinyinCharInfo.type = pinyinCharInfo.str.length() == 1 ? 2 : 3;
            pinyinCharInfoList.add(pinyinCharInfo);
            lastEnd = end;
        }
        return lastEnd;
    }

    private static List<Integer> parserSearchItem(String searchText, int start, PinyinCharInfo pinyinCharInfo) {
        if (searchText.length() <= start) {
            return null;
        }
        StringBuilder newSearchTest = new StringBuilder();
        if (searchText.charAt(start) == '[') {
            StringBuilder pinyinStr = new StringBuilder();
            int end = PinyinSearchProvider.parserString(searchText, start, pinyinStr);
            if (end == -1) {
                return null;
            }
            pinyinCharInfo.type = 1;
            pinyinCharInfo.str = pinyinStr.toString();
            ArrayList<Integer> endList = new ArrayList<Integer>();
            endList.add(end);
            return endList;
        }
        List<Integer> endList = PinyinSearchProvider.parserPinyin(searchText, start);
        if (endList == null) {
            return null;
        }
        pinyinCharInfo.type = 3;
        return endList;
    }

    private static int parserString(String searchText, int start, StringBuilder sb) {
        int i;
        if (searchText.length() + 1 <= start) {
            return -1;
        }
        if (searchText.charAt(start) != '[') {
            return -1;
        }
        block8: for (i = ++start; i < searchText.length(); ++i) {
            char c = searchText.charAt(i);
            switch (c) {
                case '\\': {
                    if (searchText.length() == i + 1) continue block8;
                    char nextChar = searchText.charAt(i + 1);
                    switch (c) {
                        case '\\': {
                            sb.append('\\');
                        }
                        case ']': {
                            sb.append(']');
                            ++i;
                            continue block8;
                        }
                    }
                    sb.append('\\');
                    continue block8;
                }
                case ']': {
                    return i + 1;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (searchText.length() == i) {
            return i;
        }
        return -1;
    }

    private static List<Integer> parserPinyin(String searchText, int start) {
        char c;
        int i;
        if (searchText.length() <= start) {
            return null;
        }
        ArrayList<Integer> endList = new ArrayList<Integer>();
        PinyinCharList nowPinyinCharList = rootPinyinChar;
        for (i = start; i < searchText.length() && (c = searchText.charAt(i)) != '\'' && nowPinyinCharList.nextCharMap.containsKey(Character.valueOf(c)); ++i) {
            nowPinyinCharList = nowPinyinCharList.nextCharMap.get(Character.valueOf(c));
            if (i != start && !nowPinyinCharList.isEnd) continue;
            endList.add(i + 1);
        }
        if (searchText.length() == i && !endList.contains(i)) {
            endList.add(i);
        }
        if (endList.isEmpty()) {
            return null;
        }
        return endList;
    }

    public ItemFilter getFilter(String searchText) {
        if (!NEISasySearchConfig.isSwitch()) {
            return null;
        }
        if (!searchText.startsWith("!")) {
            return null;
        }
        searchText = searchText.substring(1).toLowerCase();
        boolean splitPinyin = false;
        if (NEISasySearchConfig.isDebug() && searchText.endsWith("''")) {
            splitPinyin = true;
            searchText = searchText.substring(0, searchText.length() - 1);
        }
        try {
            List<PinyinCharInfo> pinyinCharInfoList = PinyinSearchProvider.parserSearchText(searchText);
            if (pinyinCharInfoList == null) {
                return null;
            }
            if (splitPinyin) {
                StringBuilder newSearchText = new StringBuilder("!");
                for (int i = 0; i < pinyinCharInfoList.size(); ++i) {
                    PinyinCharInfo pinyinCharInfo = pinyinCharInfoList.get(i);
                    if (pinyinCharInfo.type == 1) {
                        newSearchText.append('[');
                        newSearchText.append(pinyinCharInfo.str);
                        newSearchText.append(']');
                        continue;
                    }
                    newSearchText.append(pinyinCharInfo.str);
                    newSearchText.append('\'');
                }
                SubsetTag.setNEIMatchStr(newSearchText.toString());
                return null;
            }
            return new PinyinItemFilter(pinyinCharInfoList);
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Match item fail!", (Throwable)e);
            return null;
        }
    }

    static {
        List<String> sPinyinChars = PinyinUtils.sPinyinChars;
        for (String pinyin : sPinyinChars) {
            char[] pinyinChars = pinyin.toCharArray();
            PinyinCharList nowPinyinLink = rootPinyinChar;
            for (int i = 0; i < pinyinChars.length; ++i) {
                char pinyinChar = pinyinChars[i];
                if (!nowPinyinLink.nextCharMap.containsKey(Character.valueOf(pinyinChar))) {
                    nowPinyinLink.nextCharMap.put(Character.valueOf(pinyinChar), new PinyinCharList());
                }
                nowPinyinLink = nowPinyinLink.nextCharMap.get(Character.valueOf(pinyinChar));
            }
            nowPinyinLink.isEnd = true;
        }
    }

    public static class PinyinItemFilter
    implements ItemFilter {
        public static ThreadLocal<ItemStack> FILTER_ITEM = new ThreadLocal();
        public Pattern pinyinPattern = null;

        public PinyinItemFilter(List<PinyinCharInfo> pinyinCharInfoList) {
            StringBuilder patternStr = new StringBuilder();
            for (PinyinCharInfo pinyinCharInfo : pinyinCharInfoList) {
                switch (pinyinCharInfo.type) {
                    case 1: {
                        patternStr.append(pinyinCharInfo.str);
                        break;
                    }
                    case 2: {
                        patternStr.append("'[^\\]]+?,?" + pinyinCharInfo.str + "[^\\]]+?]");
                        break;
                    }
                    case 3: {
                        patternStr.append("'[^\\]]+?,?" + pinyinCharInfo.str + ",[^\\]]*?]");
                    }
                }
            }
            this.pinyinPattern = Pattern.compile(patternStr.toString());
        }

        public boolean matches(ItemStack item) {
            FILTER_ITEM.set(item);
            String s = itemSearchNames.get(item);
            if (s == null) {
                String displayName = NEISasySearchConfig.isTooltipSupport() ? ItemInfo.getSearchName((ItemStack)item) : item.func_82833_r();
                s = PinyinUtils.getHanyuPinyinMatchStr(displayName).toLowerCase();
                itemSearchNames.put(item, s);
            } else if ("".equals(s)) {
                return false;
            }
            FILTER_ITEM.remove();
            return this.pinyinPattern.matcher(s).find();
        }
    }

    public static class PinyinCharInfo {
        public static final int TYPE_UNKNOW = 0;
        public static final int TYPE_STR = 1;
        public static final int TYPE_FIRST_PINYIN = 2;
        public static final int TYPE_ALL_PINYIN = 3;
        public int type;
        public String str;
    }

    public static class PinyinCharList {
        public boolean isEnd = false;
        public HashMap<Character, PinyinCharList> nextCharMap = new HashMap();
    }
}

