/*
 * Decompiled with CFR 0.152.
 */
package mapwriter;

import java.io.File;
import mapwriter.BackgroundExecutor;
import mapwriter.BlockColourGen;
import mapwriter.ChunkManager;
import mapwriter.config.Config;
import mapwriter.config.ConfigurationHandler;
import mapwriter.config.WorldConfig;
import mapwriter.forge.MwForge;
import mapwriter.forge.MwKeyHandler;
import mapwriter.gui.MwGui;
import mapwriter.gui.MwGuiMarkerDialog;
import mapwriter.gui.MwGuiMarkerDialogNew;
import mapwriter.map.MapTexture;
import mapwriter.map.MapView;
import mapwriter.map.Marker;
import mapwriter.map.MarkerManager;
import mapwriter.map.MiniMap;
import mapwriter.map.Trail;
import mapwriter.map.UndergroundTexture;
import mapwriter.overlay.OverlaySlime;
import mapwriter.region.BlockColours;
import mapwriter.region.RegionManager;
import mapwriter.tasks.CloseRegionManagerTask;
import mapwriter.util.Logging;
import mapwriter.util.Render;
import mapwriter.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.chunk.Chunk;

public class Mw {
    public Minecraft mc = Minecraft.func_71410_x();
    private final File configDir;
    private final File saveDir;
    public File worldDir = null;
    public File imageDir = null;
    public boolean ready = false;
    public int tickCounter = 0;
    public int textureSize = 2048;
    public double playerX = 0.0;
    public double playerZ = 0.0;
    public double playerY = 0.0;
    public int playerXInt = 0;
    public int playerYInt = 0;
    public int playerZInt = 0;
    public String playerBiome = "";
    public double playerHeading = 0.0;
    public int playerDimension = 0;
    public float mapRotationDegrees = 0.0f;
    public MapTexture mapTexture = null;
    public UndergroundTexture undergroundMapTexture = null;
    public BackgroundExecutor executor = null;
    public MiniMap miniMap = null;
    public MarkerManager markerManager = null;
    public BlockColours blockColours = null;
    public RegionManager regionManager = null;
    public ChunkManager chunkManager = null;
    public Trail playerTrail = null;
    private static Mw instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Mw getInstance() {
        if (instance != null) return instance;
        Class<WorldConfig> clazz = WorldConfig.class;
        synchronized (WorldConfig.class) {
            if (instance != null) return instance;
            instance = new Mw();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private Mw() {
        this.saveDir = new File(this.mc.field_71412_D, "saves");
        this.configDir = new File(this.mc.field_71412_D, "config");
        this.ready = false;
        RegionManager.logger = MwForge.logger;
        ConfigurationHandler.loadConfig();
    }

    public void setTextureSize() {
        if (Config.configTextureSize != this.textureSize) {
            int textureSize;
            int maxTextureSize = Render.getMaxTextureSize();
            for (textureSize = 1024; textureSize <= maxTextureSize && textureSize <= Config.configTextureSize; textureSize *= 2) {
            }
            Logging.log("GL reported max texture size = %d", maxTextureSize);
            Logging.log("texture size from config = %d", Config.configTextureSize);
            Logging.log("setting map texture size to = %d", textureSize /= 2);
            this.textureSize = textureSize;
            if (this.ready) {
                this.reloadMapTexture();
            }
        }
    }

    public void updatePlayer() {
        this.playerX = this.mc.field_71439_g.field_70165_t;
        this.playerY = this.mc.field_71439_g.field_70163_u;
        this.playerZ = this.mc.field_71439_g.field_70161_v;
        this.playerXInt = (int)Math.floor(this.playerX);
        this.playerYInt = (int)Math.floor(this.playerY);
        this.playerZInt = (int)Math.floor(this.playerZ);
        if (this.mc.field_71441_e != null && !this.mc.field_71441_e.func_175726_f(new BlockPos(this.playerX, 0.0, this.playerZ)).func_76621_g()) {
            this.playerBiome = this.mc.field_71441_e.func_180494_b((BlockPos)new BlockPos((double)this.playerX, (double)0.0, (double)this.playerZ)).field_76791_y;
        }
        this.playerHeading = Math.toRadians(this.mc.field_71439_g.field_70177_z) + 1.5707963267948966;
        this.mapRotationDegrees = -this.mc.field_71439_g.field_70177_z + 180.0f;
        this.playerDimension = this.mc.field_71441_e.field_73011_w.func_177502_q();
        if (this.miniMap.view.getDimension() != this.playerDimension) {
            WorldConfig.getInstance().addDimension(this.playerDimension);
            this.miniMap.view.setDimension(this.playerDimension);
        }
    }

    public void toggleMarkerMode() {
        this.markerManager.nextGroup();
        this.markerManager.update();
        this.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("group " + this.markerManager.getVisibleGroupName() + " selected"));
    }

    public void teleportTo(int x, int y, int z) {
        if (Config.teleportEnabled) {
            this.mc.field_71439_g.func_71165_d(String.format("/%s %d %d %d", Config.teleportCommand, x, y, z));
        } else {
            Utils.printBoth(I18n.func_135052_a((String)"mw.msg.tpdisabled", (Object[])new Object[0]));
        }
    }

    public void warpTo(String name) {
        if (Config.teleportEnabled) {
            this.mc.field_71439_g.func_71165_d(String.format("/warp %s", name));
        } else {
            Utils.printBoth(I18n.func_135052_a((String)"mw.msg.tpdisabled", (Object[])new Object[0]));
        }
    }

    public void teleportToMapPos(MapView mapView, int x, int y, int z) {
        if (!Config.teleportCommand.equals("warp")) {
            double scale = mapView.getDimensionScaling(this.playerDimension);
            this.teleportTo((int)((double)x / scale), y, (int)((double)z / scale));
        } else {
            Utils.printBoth(I18n.func_135052_a((String)"mw.msg.warp.error", (Object[])new Object[0]));
        }
    }

    public void teleportToMarker(Marker marker) {
        if (Config.teleportCommand.equals("warp")) {
            this.warpTo(marker.name);
        } else if (marker.dimension == this.playerDimension) {
            this.teleportTo(marker.x, marker.y, marker.z);
        } else {
            Utils.printBoth(I18n.func_135052_a((String)"mw.msg.tp.dimError", (Object[])new Object[0]));
        }
    }

    public void loadBlockColourOverrides(BlockColours bc) {
        File f = new File(this.configDir, "MapWriterBlockColourOverrides.txt");
        if (f.isFile()) {
            Logging.logInfo("loading block colour overrides file %s", f);
            bc.loadFromFile(f);
        } else {
            Logging.logInfo("recreating block colour overrides file %s", f);
            BlockColours.writeOverridesFile(f);
            if (f.isFile()) {
                bc.loadFromFile(f);
            } else {
                Logging.logError("could not load block colour overrides from file %s", f);
            }
        }
    }

    public void saveBlockColours(BlockColours bc) {
        File f = new File(this.configDir, "MapWriterBlockColours.txt");
        Logging.logInfo("saving block colours to '%s'", f);
        bc.saveToFile(f);
    }

    public void reloadBlockColours() {
        BlockColours bc = new BlockColours();
        File f = new File(this.configDir, "MapWriterBlockColours.txt");
        if (Config.useSavedBlockColours && f.isFile() && bc.CheckFileVersion(f)) {
            Logging.logInfo("loading block colours from %s", f);
            bc.loadFromFile(f);
            this.loadBlockColourOverrides(bc);
        } else {
            Logging.logInfo("generating block colours", new Object[0]);
            BlockColourGen.genBlockColours(bc);
            this.loadBlockColourOverrides(bc);
            this.saveBlockColours(bc);
        }
        this.blockColours = bc;
    }

    public void reloadMapTexture() {
        UndergroundTexture newTexture;
        MapTexture newMapTexture;
        this.executor.addTask(new CloseRegionManagerTask(this.regionManager));
        this.executor.close();
        MapTexture oldMapTexture = this.mapTexture;
        this.mapTexture = newMapTexture = new MapTexture(this.textureSize, Config.linearTextureScaling);
        if (oldMapTexture != null) {
            oldMapTexture.close();
        }
        this.executor = new BackgroundExecutor();
        this.regionManager = new RegionManager(this.worldDir, this.imageDir, this.blockColours, Config.zoomInLevels, Config.zoomOutLevels);
        UndergroundTexture oldTexture = this.undergroundMapTexture;
        this.undergroundMapTexture = newTexture = new UndergroundTexture(this, this.textureSize, Config.linearTextureScaling);
        if (oldTexture != null) {
            this.undergroundMapTexture.close();
        }
    }

    public void toggleUndergroundMode() {
        Config.undergroundMode = !Config.undergroundMode;
        this.miniMap.view.setUndergroundMode(Config.undergroundMode);
    }

    public void load() {
        if (this.ready) {
            return;
        }
        if (this.mc.field_71441_e == null || this.mc.field_71439_g == null) {
            Logging.log("Mw.load: world or player is null, cannot load yet", new Object[0]);
            return;
        }
        Logging.log("Mw.load: loading...", new Object[0]);
        File saveDir = this.saveDir;
        if (Config.saveDirOverride.length() > 0) {
            File d = new File(Config.saveDirOverride);
            if (d.isDirectory()) {
                saveDir = d;
            } else {
                Logging.log("error: no such directory %s", Config.saveDirOverride);
            }
        }
        this.worldDir = !this.mc.func_71356_B() ? new File(new File(saveDir, "mapwriter_mp_worlds"), Utils.getWorldName()) : new File(new File(saveDir, "mapwriter_sp_worlds"), Utils.getWorldName());
        this.imageDir = new File(this.worldDir, "images");
        if (!this.imageDir.exists()) {
            this.imageDir.mkdirs();
        }
        if (!this.imageDir.isDirectory()) {
            Logging.log("Mapwriter: ERROR: could not create images directory '%s'", this.imageDir.getPath());
        }
        this.tickCounter = 0;
        this.markerManager = new MarkerManager();
        this.markerManager.load(WorldConfig.getInstance().worldConfiguration, "markers");
        this.playerTrail = new Trail(this, "player");
        this.executor = new BackgroundExecutor();
        this.mapTexture = new MapTexture(this.textureSize, Config.linearTextureScaling);
        this.undergroundMapTexture = new UndergroundTexture(this, this.textureSize, Config.linearTextureScaling);
        this.regionManager = new RegionManager(this.worldDir, this.imageDir, this.blockColours, Config.zoomInLevels, Config.zoomOutLevels);
        this.miniMap = new MiniMap(this);
        this.miniMap.view.setDimension(this.mc.field_71439_g.field_71093_bK);
        this.chunkManager = new ChunkManager(this);
        this.ready = true;
    }

    public void close() {
        Logging.log("Mw.close: closing...", new Object[0]);
        if (this.ready) {
            this.ready = false;
            this.chunkManager.close();
            this.chunkManager = null;
            this.executor.addTask(new CloseRegionManagerTask(this.regionManager));
            this.regionManager = null;
            Logging.log("waiting for %d tasks to finish...", this.executor.tasksRemaining());
            if (this.executor.close()) {
                Logging.log("error: timeout waiting for tasks to finish", new Object[0]);
            }
            Logging.log("done", new Object[0]);
            this.playerTrail.close();
            this.markerManager.save(WorldConfig.getInstance().worldConfiguration, "markers");
            this.markerManager.clear();
            this.miniMap.close();
            this.miniMap = null;
            this.undergroundMapTexture.close();
            this.mapTexture.close();
            WorldConfig.getInstance().saveWorldConfig();
            this.tickCounter = 0;
            OverlaySlime.reset();
        }
    }

    public void onTick() {
        this.load();
        if (this.ready && this.mc.field_71439_g != null) {
            this.setTextureSize();
            this.updatePlayer();
            if (Config.undergroundMode && this.tickCounter % 30 == 0) {
                this.undergroundMapTexture.update();
            }
            if (!(this.mc.field_71462_r instanceof MwGui)) {
                this.miniMap.view.setViewCentreScaled(this.playerX, this.playerZ, this.playerDimension);
                this.miniMap.drawCurrentMap();
            }
            for (int maxTasks = 50; !this.executor.processTaskQueue() && maxTasks > 0; --maxTasks) {
            }
            this.chunkManager.onTick();
            this.mapTexture.processTextureUpdates();
            this.playerTrail.onTick();
            ++this.tickCounter;
        }
    }

    public void onChunkLoad(Chunk chunk) {
        this.load();
        if (chunk != null && chunk.func_177412_p() instanceof WorldClient) {
            if (this.ready) {
                this.chunkManager.addChunk(chunk);
            } else {
                Logging.logInfo("missed chunk (%d, %d)", chunk.field_76635_g, chunk.field_76647_h);
            }
        }
    }

    public void onChunkUnload(Chunk chunk) {
        if (this.ready && chunk != null && chunk.func_177412_p() instanceof WorldClient) {
            this.chunkManager.removeChunk(chunk);
        }
    }

    public void onPlayerDeath(EntityPlayerMP player) {
        if (this.ready && Config.maxDeathMarkers > 0) {
            this.updatePlayer();
            int deleteCount = this.markerManager.countMarkersInGroup("playerDeaths") - Config.maxDeathMarkers + 1;
            for (int i = 0; i < deleteCount; ++i) {
                this.markerManager.delMarker(null, "playerDeaths");
            }
            this.markerManager.addMarker(Utils.getCurrentDateString(), "playerDeaths", this.playerXInt, this.playerYInt, this.playerZInt, this.playerDimension, -65536);
            this.markerManager.setVisibleGroupName("playerDeaths");
            this.markerManager.update();
        }
    }

    public void onKeyDown(KeyBinding kb) {
        if (this.mc.field_71462_r == null && this.ready) {
            if (kb == MwKeyHandler.keyMapMode) {
                this.miniMap.nextOverlayMode(1);
            } else if (kb == MwKeyHandler.keyMapGui) {
                this.mc.func_147108_a((GuiScreen)new MwGui(this));
            } else if (kb == MwKeyHandler.keyNewMarker) {
                String group = this.markerManager.getVisibleGroupName();
                if (group.equals("none")) {
                    group = "group";
                }
                if (Config.newMarkerDialog) {
                    this.mc.func_147108_a((GuiScreen)new MwGuiMarkerDialogNew(null, this.markerManager, "", group, this.playerXInt, this.playerYInt, this.playerZInt, this.playerDimension));
                } else {
                    this.mc.func_147108_a((GuiScreen)new MwGuiMarkerDialog(null, this.markerManager, "", group, this.playerXInt, this.playerYInt, this.playerZInt, this.playerDimension));
                }
            } else if (kb == MwKeyHandler.keyNextGroup) {
                this.markerManager.nextGroup();
                this.markerManager.update();
                this.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("group " + this.markerManager.getVisibleGroupName() + " selected"));
            } else if (kb == MwKeyHandler.keyTeleport) {
                Marker marker = this.markerManager.getNearestMarkerInDirection(this.playerXInt, this.playerZInt, this.playerHeading);
                if (marker != null) {
                    this.teleportToMarker(marker);
                }
            } else if (kb == MwKeyHandler.keyZoomIn) {
                this.miniMap.view.adjustZoomLevel(-1);
            } else if (kb == MwKeyHandler.keyZoomOut) {
                this.miniMap.view.adjustZoomLevel(1);
            } else if (kb == MwKeyHandler.keyUndergroundMode) {
                this.toggleUndergroundMode();
            }
        }
    }
}

