/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.region;

import mapwriter.region.BlockColours;
import mapwriter.region.IChunk;

public class ChunkRender {
    public static final byte FLAG_UNPROCESSED = 0;
    public static final byte FLAG_NON_OPAQUE = 1;
    public static final byte FLAG_OPAQUE = 2;
    public static final double brightenExponent = 0.35;
    public static final double darkenExponent = 0.35;
    public static final double brightenAmplitude = 0.7;
    public static final double darkenAmplitude = 1.4;

    public static double getHeightShading(int height, int heightW, int heightN) {
        int samples = 0;
        int heightDiff = 0;
        if (heightW > 0 && heightW < 255) {
            heightDiff += height - heightW;
            ++samples;
        }
        if (heightN > 0 && heightN < 255) {
            heightDiff += height - heightN;
            ++samples;
        }
        double heightDiffFactor = 0.0;
        if (samples > 0) {
            heightDiffFactor = (double)heightDiff / ((double)samples * 255.0);
        }
        return heightDiffFactor >= 0.0 ? Math.pow(heightDiffFactor, 0.35) * 0.7 : -Math.pow(-heightDiffFactor, 0.35) * 1.4;
    }

    public static int getColumnColour(BlockColours bc, IChunk chunk, int x, int y, int z, int heightW, int heightN) {
        double a = 1.0;
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        while (y > 0) {
            int blockAndMeta = chunk.getBlockAndMetadata(x, y, z);
            int c1 = bc.getColour(blockAndMeta);
            int alpha = c1 >> 24 & 0xFF;
            if (alpha > 0) {
                int biome = chunk.getBiome(x, z);
                int c2 = bc.getBiomeColour(blockAndMeta, biome);
                double c1A = (double)alpha / 255.0;
                double c1R = (double)(c1 >> 16 & 0xFF) / 255.0;
                double c1G = (double)(c1 >> 8 & 0xFF) / 255.0;
                double c1B = (double)(c1 >> 0 & 0xFF) / 255.0;
                double c2R = (double)(c2 >> 16 & 0xFF) / 255.0;
                double c2G = (double)(c2 >> 8 & 0xFF) / 255.0;
                double c2B = (double)(c2 >> 0 & 0xFF) / 255.0;
                r += a * c1A * c1R * c2R;
                g += a * c1A * c1G * c2G;
                b += a * c1A * c1B * c2B;
                a *= 1.0 - c1A;
            }
            if (alpha == 255) break;
            --y;
        }
        double heightShading = ChunkRender.getHeightShading(y, heightW, heightN);
        int lightValue = chunk.getLightValue(x, y + 1, z);
        double lightShading = (double)lightValue / 15.0;
        double shading = (heightShading + 1.0) * lightShading;
        r = Math.min(Math.max(0.0, r * shading), 1.0);
        g = Math.min(Math.max(0.0, g * shading), 1.0);
        b = Math.min(Math.max(0.0, b * shading), 1.0);
        return (y & 0xFF) << 24 | ((int)(r * 255.0) & 0xFF) << 16 | ((int)(g * 255.0) & 0xFF) << 8 | (int)(b * 255.0) & 0xFF;
    }

    static int getPixelHeightN(int[] pixels, int offset, int scanSize) {
        return offset >= scanSize ? pixels[offset - scanSize] >> 24 & 0xFF : -1;
    }

    static int getPixelHeightW(int[] pixels, int offset, int scanSize) {
        return (offset & scanSize - 1) >= 1 ? pixels[offset - 1] >> 24 & 0xFF : -1;
    }

    public static void renderSurface(BlockColours bc, IChunk chunk, int[] pixels, int offset, int scanSize, boolean dimensionHasCeiling) {
        int chunkMaxY = chunk.getMaxY();
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                int y;
                if (dimensionHasCeiling) {
                    int blockAndMeta;
                    int alpha;
                    for (y = 127; y >= 0 && (alpha = bc.getColour(blockAndMeta = chunk.getBlockAndMetadata(x, y, z)) >> 24 & 0xFF) == 255; --y) {
                    }
                } else {
                    y = chunkMaxY;
                }
                int pixelOffset = offset + z * scanSize + x;
                pixels[pixelOffset] = ChunkRender.getColumnColour(bc, chunk, x, y, z, ChunkRender.getPixelHeightW(pixels, pixelOffset, scanSize), ChunkRender.getPixelHeightN(pixels, pixelOffset, scanSize));
            }
        }
    }

    public static void renderUnderground(BlockColours bc, IChunk chunk, int[] pixels, int offset, int scanSize, int startY, byte[] mask) {
        startY = Math.min(Math.max(0, startY), 255);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                int blockAndMeta;
                int alpha;
                if (mask != null && mask[z * 16 + x] != 1) continue;
                int lastNonTransparentY = startY;
                for (int y = startY; y < chunk.getMaxY() && (alpha = bc.getColour(blockAndMeta = chunk.getBlockAndMetadata(x, y, z)) >> 24 & 0xFF) != 255; ++y) {
                    if (alpha <= 0) continue;
                    lastNonTransparentY = y;
                }
                int pixelOffset = offset + z * scanSize + x;
                pixels[pixelOffset] = ChunkRender.getColumnColour(bc, chunk, x, lastNonTransparentY, z, ChunkRender.getPixelHeightW(pixels, pixelOffset, scanSize), ChunkRender.getPixelHeightN(pixels, pixelOffset, scanSize));
            }
        }
    }
}

