/*
 * Decompiled with CFR 0.152.
 */
package mapwriter;

import mapwriter.MwUtil;
import mapwriter.Render;
import mapwriter.Texture;
import mapwriter.region.BlockColours;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.world.biome.BiomeGenBase;

public class BlockColourGen {
    private static int getIconMapColour(IIcon icon, Texture terrainTexture) {
        int iconX = Math.round((float)terrainTexture.w * Math.min(icon.func_94209_e(), icon.func_94212_f()));
        int iconY = Math.round((float)terrainTexture.h * Math.min(icon.func_94206_g(), icon.func_94210_h()));
        int iconWidth = Math.round((float)terrainTexture.w * Math.abs(icon.func_94212_f() - icon.func_94209_e()));
        int iconHeight = Math.round((float)terrainTexture.h * Math.abs(icon.func_94210_h() - icon.func_94206_g()));
        int[] pixels = new int[iconWidth * iconHeight];
        terrainTexture.getRGB(iconX, iconY, iconWidth, iconHeight, pixels, 0, iconWidth, icon);
        return Render.getAverageColourOfArray(pixels);
    }

    private static int adjustBlockColourFromType(BlockColours bc, int blockAndMeta, int blockColour) {
        int blockid = blockAndMeta >> 4;
        Block block = (Block)Block.field_149771_c.func_148754_a(blockid);
        BlockColours.BlockType blockType = bc.getBlockType(blockAndMeta);
        switch (blockType) {
            case OPAQUE: {
                blockColour |= 0xFF000000;
            }
            case NORMAL: {
                try {
                    int renderColour = block.func_149741_i(blockAndMeta & 0xF);
                    if (renderColour == 0xFFFFFF) break;
                    blockColour = Render.multiplyColours(blockColour, 0xFF000000 | renderColour);
                }
                catch (RuntimeException e) {}
                break;
            }
            case LEAVES: {
                blockColour |= 0xFF000000;
                break;
            }
        }
        return blockColour;
    }

    private static void genBiomeColours(BlockColours bc) {
        for (int i = 0; i < BiomeGenBase.func_150565_n().length; ++i) {
            if (BiomeGenBase.func_150565_n()[i] != null) {
                bc.setBiomeWaterShading(i, BiomeGenBase.func_150565_n()[i].getWaterColorMultiplier() & 0xFFFFFF);
                bc.setBiomeGrassShading(i, BiomeGenBase.func_150565_n()[i].func_150558_b(0, 0, 0) & 0xFFFFFF);
                bc.setBiomeFoliageShading(i, BiomeGenBase.func_150565_n()[i].func_150571_c(0, 0, 0) & 0xFFFFFF);
                continue;
            }
            bc.setBiomeWaterShading(i, 0xFFFFFF);
            bc.setBiomeGrassShading(i, 0xFFFFFF);
            bc.setBiomeFoliageShading(i, 0xFFFFFF);
        }
    }

    public static void genBlockColours(BlockColours bc) {
        MwUtil.log("generating block map colours from textures", new Object[0]);
        int terrainTextureId = Minecraft.func_71410_x().field_71446_o.func_110581_b(TextureMap.field_110575_b).func_110552_b();
        if (terrainTextureId == 0) {
            MwUtil.log("error: could get terrain texture ID", new Object[0]);
            return;
        }
        Texture terrainTexture = new Texture(terrainTextureId);
        double u1Last = 0.0;
        double u2Last = 0.0;
        double v1Last = 0.0;
        double v2Last = 0.0;
        int blockColourLast = 0;
        int e_count = 0;
        int b_count = 0;
        int s_count = 0;
        for (Object oblock : Block.field_149771_c) {
            Block block = (Block)oblock;
            int blockID = Block.func_149682_b((Block)block);
            for (int dv = 0; dv < 17; ++dv) {
                int blockAndMeta = (blockID & 0xFFF) << 4 | dv & 0xF;
                int blockColour = 0;
                if (block != null) {
                    IIcon icon = null;
                    try {
                        icon = block.func_149691_a(1, dv);
                    }
                    catch (Exception e) {
                        ++e_count;
                    }
                    if (icon != null) {
                        double u1 = icon.func_94209_e();
                        double u2 = icon.func_94212_f();
                        double v1 = icon.func_94206_g();
                        double v2 = icon.func_94210_h();
                        if (u1 == u1Last && u2 == u2Last && v1 == v1Last && v2 == v2Last) {
                            blockColour = blockColourLast;
                            ++s_count;
                        } else {
                            blockColour = BlockColourGen.getIconMapColour(icon, terrainTexture);
                            if (Block.field_149771_c.func_148750_c((Object)block).contains("CarpentersBlocks")) {
                                icon = block.func_149691_a(1, 16);
                                blockColour = BlockColourGen.getIconMapColour(icon, terrainTexture);
                            }
                            u1Last = u1;
                            u2Last = u2;
                            v1Last = v1;
                            v2Last = v2;
                            blockColourLast = blockColour;
                            ++b_count;
                        }
                    }
                    blockColour = BlockColourGen.adjustBlockColourFromType(bc, blockAndMeta, blockColour);
                }
                bc.setColour(blockAndMeta, blockColour);
            }
        }
        MwUtil.log("processed %d block textures, %d skipped, %d exceptions", b_count, s_count, e_count);
        BlockColourGen.genBiomeColours(bc);
    }
}

