/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.util;

import java.nio.IntBuffer;
import mapwriter.util.Logging;
import mapwriter.util.Render;
import mapwriter.util.Utils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fml.client.SplashProgress;
import org.lwjgl.opengl.GL11;

public class Texture {
    private int id;
    public final int w;
    public final int h;
    private final IntBuffer pixelBuf;

    public Texture(int id) {
        this.id = id;
        this.bind();
        this.w = Render.getTextureWidth();
        this.h = Render.getTextureHeight();
        this.pixelBuf = Utils.allocateDirectIntBuffer(this.w * this.h);
        this.getPixelsFromExistingTexture();
        Logging.log("created new MwTexture from GL texture id %d (%dx%d) (%d pixels)", this.id, this.w, this.h, this.pixelBuf.limit());
    }

    public Texture(int w, int h, int fillColour) {
        this(w, h, fillColour, 9729, 9728, 33071);
    }

    public Texture(int w, int h, int fillColour, int minFilter, int maxFilter, int textureWrap) {
        this.id = GlStateManager.func_179146_y();
        this.w = w;
        this.h = h;
        this.pixelBuf = Utils.allocateDirectIntBuffer(w * h);
        this.fillRect(0, 0, w, h, fillColour);
        this.pixelBuf.position(0);
        this.bind();
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)w, (int)h, (int)0, (int)32993, (int)5121, (IntBuffer)this.pixelBuf);
        this.setTexParameters(minFilter, maxFilter, textureWrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind() {
        Class<SplashProgress> clazz = SplashProgress.class;
        synchronized (SplashProgress.class) {
            GlStateManager.func_179144_i((int)this.id);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public synchronized void close() {
        if (this.id != 0) {
            try {
                GlStateManager.func_179150_h((int)this.id);
            }
            catch (NullPointerException e) {
                Logging.log("MwTexture.close: null pointer exception (texture %d)", this.id);
            }
            this.id = 0;
        }
    }

    public synchronized void fillRect(int x, int y, int w, int h, int colour) {
        int offset = y * this.w + x;
        for (int j = 0; j < h; ++j) {
            this.pixelBuf.position(offset + j * this.w);
            for (int i = 0; i < w; ++i) {
                this.pixelBuf.put(colour);
            }
        }
    }

    public synchronized int getRGB(int x, int y) {
        return this.pixelBuf.get(y * this.w + x);
    }

    public synchronized void getRGB(int x, int y, int w, int h, int[] pixels, int offset, int scanSize, TextureAtlasSprite icon) {
        int bufOffset = y * this.w + x;
        for (int i = 0; i < h; ++i) {
            try {
                this.pixelBuf.position(bufOffset + i * this.w);
                this.pixelBuf.get(pixels, offset + i * scanSize, w);
                continue;
            }
            catch (IllegalArgumentException e) {
                Logging.logWarning("MwTexture.getRGB: IllegalArgumentException (icon name: %s; height: %d; width: %d; MaxU: %f; MinU: %f; MaxV: %f; MinV: %f)", icon.func_94215_i(), icon.func_94216_b(), icon.func_94211_a(), Float.valueOf(icon.func_94212_f()), Float.valueOf(icon.func_94209_e()), Float.valueOf(icon.func_94210_h()), Float.valueOf(icon.func_94206_g()));
                Logging.logWarning("MwTexture.getRGB: IllegalArgumentException (pos: %d)", bufOffset + i * this.w);
                Logging.logWarning("MwTexture.getRGB: IllegalArgumentException (buffersize: %d)", this.pixelBuf.limit());
            }
        }
    }

    public void pixelBufPut(int pixel) {
        this.pixelBuf.put(pixel);
    }

    public void setLinearScaling(boolean enabled) {
        this.bind();
        if (enabled) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
    }

    public void setPixelBufPosition(int i) {
        this.pixelBuf.position(i);
    }

    public synchronized void setRGB(int x, int y, int colour) {
        this.pixelBuf.put(y * this.w + x, colour);
    }

    public synchronized void setRGB(int x, int y, int w, int h, int[] pixels, int offset, int scanSize) {
        int bufOffset = y * this.w + x;
        for (int i = 0; i < h; ++i) {
            this.pixelBuf.position(bufOffset + i * this.w);
            this.pixelBuf.put(pixels, offset + i * scanSize, w);
        }
    }

    public void setTexParameters(int minFilter, int maxFilter, int textureWrap) {
        this.bind();
        GL11.glTexParameteri((int)3553, (int)10242, (int)textureWrap);
        GL11.glTexParameteri((int)3553, (int)10243, (int)textureWrap);
        GL11.glTexParameteri((int)3553, (int)10241, (int)minFilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)maxFilter);
    }

    public synchronized void updateTexture() {
        this.bind();
        this.pixelBuf.position(0);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)this.w, (int)this.h, (int)0, (int)32993, (int)5121, (IntBuffer)this.pixelBuf);
    }

    public synchronized void updateTextureArea(int x, int y, int w, int h) {
        try {
            this.bind();
            GL11.glPixelStorei((int)3314, (int)this.w);
            this.pixelBuf.position(y * this.w + x);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)x, (int)y, (int)w, (int)h, (int)32993, (int)5121, (IntBuffer)this.pixelBuf);
            GL11.glPixelStorei((int)3314, (int)0);
        }
        catch (NullPointerException e) {
            Logging.log("MwTexture.updatePixels: null pointer exception (texture %d)", this.id);
        }
    }

    private synchronized void getPixelsFromExistingTexture() {
        try {
            this.bind();
            this.pixelBuf.clear();
            GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)5121, (IntBuffer)this.pixelBuf);
            this.pixelBuf.limit(this.w * this.h);
        }
        catch (NullPointerException e) {
            Logging.log("MwTexture.getPixels: null pointer exception (texture %d)", this.id);
        }
    }
}

