/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.region;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import mapwriter.region.BlockColours;
import mapwriter.region.MwChunk;
import mapwriter.region.Region;
import mapwriter.region.RegionFileCache;
import mapwriter.util.Logging;
import org.apache.logging.log4j.Logger;

public class RegionManager {
    public static Logger logger;
    private final LruCache regionMap;
    public final File worldDir;
    public final File imageDir;
    public BlockColours blockColours;
    public final RegionFileCache regionFileCache;
    public int maxZoom;
    public int minZoom;

    private static int incrStatsCounter(Map<String, Integer> h, String key) {
        int n = 1;
        if (h.containsKey(key)) {
            n = h.get(key) + 1;
        }
        h.put(key, n);
        return n;
    }

    public RegionManager(File worldDir, File imageDir, BlockColours blockColours, int minZoom, int maxZoom) {
        this.worldDir = worldDir;
        this.imageDir = imageDir;
        this.blockColours = blockColours;
        this.regionMap = new LruCache();
        this.regionFileCache = new RegionFileCache(worldDir);
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
    }

    public void close() {
        for (Region region : this.regionMap.values()) {
            if (region == null) continue;
            region.close();
        }
        this.regionMap.clear();
        this.regionFileCache.close();
    }

    public Region getRegion(int x, int z, int zoomLevel, int dimension) {
        Region region = (Region)this.regionMap.get(Region.getKey(x, z, zoomLevel, dimension));
        if (region == null) {
            region = new Region(this, x, z, zoomLevel, dimension);
            this.regionMap.put(region.key, region);
        }
        return region;
    }

    public void printLoadedRegionStats() {
        Logging.logInfo("loaded region listing:", new Object[0]);
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        for (Region region : this.regionMap.values()) {
            Logging.logInfo("  %s", region);
            RegionManager.incrStatsCounter(stats, String.format("dim%d", region.dimension));
            RegionManager.incrStatsCounter(stats, String.format("zoom%d", region.zoomLevel));
            RegionManager.incrStatsCounter(stats, "total");
        }
        Logging.logInfo("loaded region stats:", new Object[0]);
        for (Map.Entry entry : stats.entrySet()) {
            Logging.logInfo("  %s: %d", entry.getKey(), entry.getValue());
        }
    }

    public void rebuildRegions(int xStart, int zStart, int w, int h, int dimension) {
        w = w + 512 & 0xFFFFFE00;
        h = h + 512 & 0xFFFFFE00;
        Logging.logInfo("rebuilding regions from (%d, %d) to (%d, %d)", xStart &= 0xFFFFFE00, zStart &= 0xFFFFFE00, xStart + w, zStart + h);
        for (int rX = xStart; rX < xStart + w; rX += 512) {
            for (int rZ = zStart; rZ < zStart + h; rZ += 512) {
                Region region = this.getRegion(rX, rZ, 0, dimension);
                if (this.regionFileCache.regionFileExists(rX, rZ, dimension)) {
                    region.clear();
                    for (int cz = 0; cz < 32; ++cz) {
                        for (int cx = 0; cx < 32; ++cx) {
                            MwChunk chunk = MwChunk.read((region.x >> 4) + cx, (region.z >> 4) + cz, region.dimension, this.regionFileCache);
                            region.updateChunk(chunk);
                        }
                    }
                }
                region.updateZoomLevels();
            }
        }
    }

    public void updateChunk(MwChunk chunk) {
        Region region = this.getRegion(chunk.x << 4, chunk.z << 4, 0, chunk.dimension);
        region.updateChunk(chunk);
    }

    class LruCache
    extends LinkedHashMap<Long, Region> {
        private static final long serialVersionUID = 1L;
        private static final int MAX_LOADED_REGIONS = 64;

        public LruCache() {
            super(128, 0.5f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, Region> entry) {
            boolean ret = false;
            if (this.size() > 64) {
                Region region = entry.getValue();
                region.close();
                ret = true;
            }
            return ret;
        }
    }
}

