/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.region;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import mapwriter.util.Logging;
import mapwriter.util.Render;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;

public class BlockColours {
    public static final int MAX_META = 16;
    public static final String biomeSectionString = "[biomes]";
    public static final String blockSectionString = "[blocks]";
    private LinkedHashMap<String, BiomeData> biomeMap = new LinkedHashMap();
    private LinkedHashMap<String, BlockData> bcMap = new LinkedHashMap();

    public static int getColourFromString(String s) {
        return (int)(Long.parseLong(s, 16) & 0xFFFFFFFFL);
    }

    public static void writeOverridesFile(File f) {
        Writer fout = null;
        try {
            fout = new OutputStreamWriter(new FileOutputStream(f));
            fout.write(String.format("version: %s\n", "2.8.2"));
            fout.write("block minecraft:yellow_flower * 60ffff00\t# make dandelions more yellow\nblock minecraft:red_flower 0 60ff0000\t\t# make poppy more red\nblock minecraft:red_flower 1 601c92d6\t\t# make Blue Orchid more red\nblock minecraft:red_flower 2 60b865fb\t\t# make Allium more red\nblock minecraft:red_flower 3 60e4eaf2\t\t# make Azure Bluet more red\nblock minecraft:red_flower 4 60d33a17\t\t# make Red Tulip more red\nblock minecraft:red_flower 5 60e17124\t\t# make Orange Tulip more red\nblock minecraft:red_flower 6 60ffffff\t\t# make White Tulip more red\nblock minecraft:red_flower 7 60eabeea\t\t# make Pink Tulip more red\nblock minecraft:red_flower 8 60eae6ad\t\t# make Oxeye Daisy more red\nblock minecraft:double_plant 0 60ffff00\t\t# make Sunflower more Yellow-orrange\nblock minecraft:double_plant 1 d09f78a4\t\t# make Lilac more pink\nblock minecraft:double_plant 4 60ff0000\t\t# make Rose Bush more red\nblock minecraft:double_plant 5 d0e3b8f7\t\t# make Peony more red\nblocktype minecraft:grass * grass\t\t\t# grass block\nblocktype minecraft:flowing_water * water\t# flowing water block\nblocktype minecraft:water * water\t\t\t# still water block\nblocktype minecraft:leaves * leaves    \t\t# leaves block\nblocktype minecraft:leaves2 * leaves    \t\t# leaves block\nblocktype minecraft:leaves 1 opaque    \t\t# pine leaves (not biome colorized)\nblocktype minecraft:leaves 2 opaque    \t\t# birch leaves (not biome colorized)\nblocktype minecraft:tallgrass * grass     \t# tall grass block\nblocktype minecraft:vine * foliage  \t\t\t# vines block\nblocktype biomesoplenty:grass * grass\t\t# BOP grass block\nblocktype biomesoplenty:plant_0 * grass\t\t# BOP plant block\nblocktype biomesoplenty:plant_1 * grass\t\t# BOP plant block\nblocktype biomesoplenty:leaves_0 * leaves\t# BOP Leave block\nblocktype biomesoplenty:leaves_1 * leaves\t# BOP Leave block\nblocktype biomesoplenty:leaves_2 * leaves\t# BOP Leave block\nblocktype biomesoplenty:leaves_3 * leaves\t# BOP Leave block\nblocktype biomesoplenty:leaves_4 * leaves\t# BOP Leave block\nblocktype biomesoplenty:leaves_5 * leaves\t# BOP Leave block\nblocktype biomesoplenty:tree_moss * foliage\t# biomes o plenty tree moss\n");
        }
        catch (IOException e) {
            Logging.logError("saving block overrides: could not write to '%s'", f);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static int adjustBlockColourFromType(String BlockName, String meta, BlockType type, int blockColour) {
        Block block = Block.func_149684_b((String)BlockName);
        switch (type) {
            case OPAQUE: {
                blockColour |= 0xFF000000;
            }
            case NORMAL: {
                try {
                    int renderColour = block.func_180659_g((IBlockState)block.func_176203_a((int)(Integer.parseInt((String)meta) & 0xF)), null, null).field_76291_p;
                    if (renderColour == 0xFFFFFF) break;
                    blockColour = Render.multiplyColours(blockColour, 0xFF000000 | renderColour);
                }
                catch (RuntimeException runtimeException) {}
                break;
            }
            case LEAVES: {
                blockColour |= 0xFF000000;
                break;
            }
            case GRASS: {
                blockColour = -6579301;
            }
        }
        return blockColour;
    }

    private static String getBlockTypeAsString(BlockType blockType) {
        String s = "normal";
        switch (blockType) {
            case NORMAL: {
                s = "normal";
                break;
            }
            case GRASS: {
                s = "grass";
                break;
            }
            case LEAVES: {
                s = "leaves";
                break;
            }
            case FOLIAGE: {
                s = "foliage";
                break;
            }
            case WATER: {
                s = "water";
                break;
            }
            case OPAQUE: {
                s = "opaque";
            }
        }
        return s;
    }

    private static BlockType getBlockTypeFromString(String typeString) {
        BlockType blockType = BlockType.NORMAL;
        if (typeString.equalsIgnoreCase("normal")) {
            blockType = BlockType.NORMAL;
        } else if (typeString.equalsIgnoreCase("grass")) {
            blockType = BlockType.GRASS;
        } else if (typeString.equalsIgnoreCase("leaves")) {
            blockType = BlockType.LEAVES;
        } else if (typeString.equalsIgnoreCase("foliage")) {
            blockType = BlockType.FOLIAGE;
        } else if (typeString.equalsIgnoreCase("water")) {
            blockType = BlockType.WATER;
        } else if (typeString.equalsIgnoreCase("opaque")) {
            blockType = BlockType.OPAQUE;
        } else {
            Logging.logWarning("unknown block type '%s'", typeString);
        }
        return blockType;
    }

    private static String getMostOccurringKey(Map<String, Integer> map, String defaultItem) {
        int maxCount = 1;
        String mostOccurringKey = defaultItem;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String key = entry.getKey();
            int count = entry.getValue();
            if (count <= maxCount) continue;
            maxCount = count;
            mostOccurringKey = key;
        }
        return mostOccurringKey;
    }

    private static void writeMinimalBlockLines(Writer fout, String lineStart, List<String> items, String defaultItem) throws IOException {
        HashMap<String, Integer> frequencyMap = new HashMap<String, Integer>();
        for (String item : items) {
            int count = 0;
            if (frequencyMap.containsKey(item)) {
                count = (Integer)frequencyMap.get(item);
            }
            frequencyMap.put(item, count + 1);
        }
        String mostOccurringItem = BlockColours.getMostOccurringKey(frequencyMap, defaultItem);
        if (!mostOccurringItem.equals(defaultItem)) {
            fout.write(String.format("%s * %s\n", lineStart, mostOccurringItem));
        }
        int meta = 0;
        for (String s : items) {
            if (!s.equals(mostOccurringItem) && !s.equals(defaultItem)) {
                fout.write(String.format("%s %d %s\n", lineStart, meta, s));
            }
            ++meta;
        }
    }

    public boolean CheckFileVersion(File fn) {
        String lineData = "";
        try {
            RandomAccessFile inFile = new RandomAccessFile(fn, "rw");
            lineData = inFile.readLine();
            inFile.close();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        return lineData.equals(String.format("version: %s", "2.8.2"));
    }

    public String CombineBlockMeta(String BlockName, int meta) {
        return BlockName + " " + meta;
    }

    public String CombineBlockMeta(String BlockName, String meta) {
        return BlockName + " " + meta;
    }

    public int getBiomeColour(IBlockState BlockState, int biomeId) {
        String biomeName = "";
        Biome biome = Biome.func_185357_a((int)biomeId);
        if (biomeId == 255) {
            biome = Biomes.field_76772_c;
        }
        if (biome != null) {
            biomeName = biome.func_185359_l();
        }
        Block block = BlockState.func_177230_c();
        int meta = block.func_176201_c(BlockState);
        return this.getBiomeColour(block.delegate.name().toString(), meta, biomeName);
    }

    public int getBiomeColour(String BlockName, int meta, String biomeName) {
        int colourMultiplier = 0xFFFFFF;
        if (this.bcMap.containsKey(this.CombineBlockMeta(BlockName, meta))) {
            switch (this.bcMap.get((Object)this.CombineBlockMeta((String)BlockName, (int)meta)).type) {
                case GRASS: {
                    colourMultiplier = this.getGrassColourMultiplier(biomeName);
                    break;
                }
                case LEAVES: 
                case FOLIAGE: {
                    colourMultiplier = this.getFoliageColourMultiplier(biomeName);
                    break;
                }
                case WATER: {
                    colourMultiplier = this.getWaterColourMultiplier(biomeName);
                    break;
                }
                default: {
                    colourMultiplier = 0xFFFFFF;
                }
            }
        }
        return colourMultiplier;
    }

    public BlockType getBlockType(int BlockAndMeta) {
        Block block = Block.func_149729_e((int)(BlockAndMeta >> 4));
        int meta = BlockAndMeta & 0xF;
        return this.getBlockType(block.delegate.name().toString(), meta);
    }

    public BlockType getBlockType(String BlockName, int meta) {
        String BlockAndMeta = this.CombineBlockMeta(BlockName, meta);
        String BlockAndWildcard = this.CombineBlockMeta(BlockName, "*");
        BlockData data = new BlockData();
        if (this.bcMap.containsKey(BlockAndMeta)) {
            data = this.bcMap.get(BlockAndMeta);
        } else if (this.bcMap.containsKey(BlockAndWildcard)) {
            data = this.bcMap.get(BlockAndWildcard);
        }
        return data.type;
    }

    public int getColour(IBlockState BlockState) {
        Block block = BlockState.func_177230_c();
        int meta = block.func_176201_c(BlockState);
        if (block.delegate == null) {
            Logging.logError("Delegate was Null when getting colour, Block in: %s", block.toString());
            return 0;
        }
        if (block.delegate.name() == null) {
            Logging.logError("Block Name was Null when getting colour, Block in: %s, Delegate: %s", block.toString(), block.delegate.toString());
            return 0;
        }
        return this.getColour(block.delegate.name().toString(), meta);
    }

    public int getColour(String BlockName, int meta) {
        String BlockAndMeta = this.CombineBlockMeta(BlockName, meta);
        String BlockAndWildcard = this.CombineBlockMeta(BlockName, "*");
        BlockData data = new BlockData();
        if (this.bcMap.containsKey(BlockAndMeta)) {
            data = this.bcMap.get(BlockAndMeta);
        } else if (this.bcMap.containsKey(BlockAndWildcard)) {
            data = this.bcMap.get(BlockAndWildcard);
        }
        return data.color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(File f) {
        Scanner fin = null;
        try {
            fin = new Scanner(new FileReader(f));
            while (fin.hasNextLine()) {
                String line = fin.nextLine().split("#")[0].trim();
                if (line.length() <= 0) continue;
                String[] lineSplit = line.split(" ");
                if (lineSplit[0].equals("biome") && lineSplit.length == 5) {
                    this.loadBiomeLine(lineSplit);
                    continue;
                }
                if (lineSplit[0].equals("block") && lineSplit.length == 4) {
                    this.loadBlockLine(lineSplit);
                    continue;
                }
                if (lineSplit[0].equals("blocktype") && lineSplit.length == 4) {
                    this.loadBlockTypeLine(lineSplit);
                    continue;
                }
                if (lineSplit[0].equals("version:")) continue;
                Logging.logWarning("invalid map colour line '%s'", line);
            }
        }
        catch (IOException e) {
            Logging.logError("loading block colours: no such file '%s'", f);
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
    }

    public void saveBiomes(Writer fout) throws IOException {
        fout.write("biome * ffffff ffffff ffffff\n");
        for (Map.Entry<String, BiomeData> entry : this.biomeMap.entrySet()) {
            String biomeName = entry.getKey();
            BiomeData data = entry.getValue();
            if (data.waterMultiplier == 0xFFFFFF && data.grassMultiplier == 0xFFFFFF && data.foliageMultiplier == 0xFFFFFF) continue;
            fout.write(String.format("biome %s %06x %06x %06x\n", biomeName, data.waterMultiplier, data.grassMultiplier, data.foliageMultiplier));
        }
    }

    public void saveBlocks(Writer fout) throws IOException {
        fout.write("block * * 00000000\n");
        String LastBlock = "";
        ArrayList<String> colours = new ArrayList<String>();
        for (Map.Entry<String, BlockData> entry : this.bcMap.entrySet()) {
            String[] BlockAndMeta = entry.getKey().split(" ");
            String block = BlockAndMeta[0];
            String color = String.format("%08x", entry.getValue().color);
            if (!LastBlock.equals(block) && !LastBlock.isEmpty()) {
                String lineStart = String.format("block %s", LastBlock);
                BlockColours.writeMinimalBlockLines(fout, lineStart, colours, "00000000");
                colours.clear();
            }
            colours.add(color);
            LastBlock = block;
        }
    }

    public void saveBlockTypes(Writer fout) throws IOException {
        fout.write("blocktype * * normal\n");
        String LastBlock = "";
        ArrayList<String> blockTypes = new ArrayList<String>();
        for (Map.Entry<String, BlockData> entry : this.bcMap.entrySet()) {
            String[] BlockAndMeta = entry.getKey().split(" ");
            String block = BlockAndMeta[0];
            String Type2 = BlockColours.getBlockTypeAsString(entry.getValue().type);
            if (!LastBlock.equals(block) && !LastBlock.isEmpty()) {
                String lineStart = String.format("blocktype %s", LastBlock);
                BlockColours.writeMinimalBlockLines(fout, lineStart, blockTypes, BlockColours.getBlockTypeAsString(BlockType.NORMAL));
                blockTypes.clear();
            }
            blockTypes.add(Type2);
            LastBlock = block;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File f) {
        Writer fout = null;
        try {
            fout = new OutputStreamWriter(new FileOutputStream(f));
            fout.write(String.format("version: %s\n", "2.8.2"));
            this.saveBiomes(fout);
            this.saveBlockTypes(fout);
            this.saveBlocks(fout);
        }
        catch (IOException e) {
            Logging.logError("saving block colours: could not write to '%s'", f);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setBiomeData(String biomeName, int waterShading, int grassShading, int foliageShading) {
        BiomeData data = new BiomeData();
        data.foliageMultiplier = foliageShading;
        data.grassMultiplier = grassShading;
        data.waterMultiplier = waterShading;
        this.biomeMap.put(biomeName, data);
    }

    public void setBlockType(String BlockName, String meta, BlockType type) {
        String BlockAndMeta = this.CombineBlockMeta(BlockName, meta);
        if (meta.equals("*")) {
            for (int i = 0; i < 16; ++i) {
                this.setBlockType(BlockName, String.valueOf(i), type);
            }
            return;
        }
        if (this.bcMap.containsKey(BlockAndMeta)) {
            BlockData data = this.bcMap.get(BlockAndMeta);
            data.type = type;
            data.color = BlockColours.adjustBlockColourFromType(BlockName, meta, type, data.color);
        } else {
            BlockData data = new BlockData();
            data.type = type;
            this.bcMap.put(BlockAndMeta, data);
        }
    }

    public void setColour(String BlockName, String meta, int colour) {
        String BlockAndMeta = this.CombineBlockMeta(BlockName, meta);
        if (meta.equals("*")) {
            for (int i = 0; i < 16; ++i) {
                this.setColour(BlockName, String.valueOf(i), colour);
            }
        }
        if (this.bcMap.containsKey(BlockAndMeta)) {
            BlockData data = this.bcMap.get(BlockAndMeta);
            data.color = colour;
        } else {
            BlockData data = new BlockData();
            data.color = colour;
            this.bcMap.put(BlockAndMeta, data);
        }
    }

    private int getFoliageColourMultiplier(String biomeName) {
        BiomeData data = this.biomeMap.get(biomeName);
        return data != null ? data.foliageMultiplier : 0xFFFFFF;
    }

    private int getGrassColourMultiplier(String biomeName) {
        BiomeData data = this.biomeMap.get(biomeName);
        return data != null ? data.grassMultiplier : 0xFFFFFF;
    }

    private int getWaterColourMultiplier(String biomeName) {
        BiomeData data = this.biomeMap.get(biomeName);
        return data != null ? data.waterMultiplier : 0xFFFFFF;
    }

    private void loadBiomeLine(String[] split) {
        try {
            int waterMultiplier = BlockColours.getColourFromString(split[2]) & 0xFFFFFF;
            int grassMultiplier = BlockColours.getColourFromString(split[3]) & 0xFFFFFF;
            int foliageMultiplier = BlockColours.getColourFromString(split[4]) & 0xFFFFFF;
            this.setBiomeData(split[1], waterMultiplier, grassMultiplier, foliageMultiplier);
        }
        catch (NumberFormatException e) {
            Logging.logWarning("invalid biome colour line '%s %s %s %s %s'", split[0], split[1], split[2], split[3], split[4]);
        }
    }

    private void loadBlockLine(String[] split) {
        try {
            int colour = BlockColours.getColourFromString(split[3]);
            this.setColour(split[1], split[2], colour);
        }
        catch (NumberFormatException e) {
            Logging.logWarning("invalid block colour line '%s %s %s %s'", split[0], split[1], split[2], split[3]);
        }
    }

    private void loadBlockTypeLine(String[] split) {
        try {
            BlockType type = BlockColours.getBlockTypeFromString(split[3]);
            this.setBlockType(split[1], split[2], type);
        }
        catch (NumberFormatException e) {
            Logging.logWarning("invalid block colour line '%s %s %s %s'", split[0], split[1], split[2], split[3]);
        }
    }

    public static enum BlockType {
        NORMAL,
        GRASS,
        LEAVES,
        FOLIAGE,
        WATER,
        OPAQUE;

    }

    public class BlockData {
        public int color = 0;
        public BlockType type = BlockType.NORMAL;
    }

    public class BiomeData {
        private int waterMultiplier = 0;
        private int grassMultiplier = 0;
        private int foliageMultiplier = 0;
    }
}

