/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.map;

import java.util.ArrayList;
import java.util.List;
import mapwriter.Mw;
import mapwriter.config.Config;
import mapwriter.map.MapRenderer;
import mapwriter.map.MapView;
import mapwriter.map.mapmode.MapMode;

public class MiniMap {
    public MapMode smallMapMode;
    public MapMode largeMapMode;
    public MapMode guiMapMode;
    public MapView view;
    public MapRenderer smallMap;
    public MapRenderer largeMap;
    private List<MapRenderer> mapList;
    private MapRenderer currentMap = null;

    public MiniMap(Mw mw) {
        this.view = new MapView(mw, false);
        this.view.setZoomLevel(Config.overlayZoomLevel);
        this.smallMapMode = new MapMode(Config.smallMap);
        this.smallMap = new MapRenderer(mw, this.smallMapMode, this.view);
        this.largeMapMode = new MapMode(Config.largeMap);
        this.largeMap = new MapRenderer(mw, this.largeMapMode, this.view);
        this.mapList = new ArrayList<MapRenderer>();
        if (this.smallMapMode.getConfig().enabled) {
            this.mapList.add(this.smallMap);
        }
        if (this.largeMapMode.getConfig().enabled) {
            this.mapList.add(this.largeMap);
        }
        this.mapList.add(null);
        this.nextOverlayMode(0);
        this.currentMap = this.mapList.get(Config.overlayModeIndex);
    }

    public void close() {
        this.mapList.clear();
        this.currentMap = null;
    }

    public void drawCurrentMap() {
        if (this.currentMap != null) {
            this.currentMap.draw();
        }
    }

    public MapRenderer nextOverlayMode(int increment) {
        MapRenderer newMap;
        int size = this.mapList.size();
        Config.overlayModeIndex = (Config.overlayModeIndex + size + increment) % size;
        this.currentMap = newMap = this.mapList.get(Config.overlayModeIndex);
        return this.currentMap;
    }
}

