/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.config;

import mapwriter.api.IMapModeConfig;
import mapwriter.config.ConfigurationHandler;
import mapwriter.gui.ModGuiConfig;
import mapwriter.gui.ModGuiConfigHUD;

public class MapModeConfig
implements IMapModeConfig {
    public static final String[] coordsModeStringArray = new String[]{"mw.config.map.coordsMode.disabled", "mw.config.map.coordsMode.small", "mw.config.map.coordsMode.large"};
    public final String configCategory;
    public final String mapPosCategory;
    public boolean enabledDef;
    public boolean enabled;
    public boolean rotateDef;
    public boolean rotate;
    public boolean circularDef;
    public boolean circular;
    public String coordsModeDef;
    public String coordsMode;
    public boolean borderModeDef;
    public boolean borderMode;
    public int playerArrowSizeDef;
    public int playerArrowSize;
    public int markerSizeDef;
    public int markerSize;
    public int trailMarkerSizeDef;
    public int trailMarkerSize;
    public int alphaPercentDef;
    public int alphaPercent;
    public String biomeModeDef;
    public String biomeMode;
    public double xPosDef;
    public double xPos;
    public double yPosDef;
    public double yPos;
    public double heightPercentDef;
    public double heightPercent;
    public double widthPercentDef;
    public double widthPercent;

    public MapModeConfig(String configCategory) {
        this.enabled = this.enabledDef = true;
        this.rotate = this.rotateDef = false;
        this.circular = this.circularDef = false;
        this.coordsMode = this.coordsModeDef = coordsModeStringArray[0];
        this.borderMode = this.borderModeDef = false;
        this.playerArrowSize = this.playerArrowSizeDef = 5;
        this.markerSize = this.markerSizeDef = 5;
        this.trailMarkerSize = this.trailMarkerSizeDef = 3;
        this.alphaPercent = this.alphaPercentDef = 100;
        this.biomeMode = this.biomeModeDef = coordsModeStringArray[0];
        this.xPos = this.xPosDef = 0.0;
        this.yPos = this.yPosDef = 0.0;
        this.heightPercent = this.heightPercentDef = 100.0;
        this.widthPercent = this.widthPercentDef = 100.0;
        this.configCategory = configCategory;
        this.mapPosCategory = configCategory + "." + "mappos";
    }

    @Override
    public int getAlphaPercent() {
        return this.alphaPercent;
    }

    @Override
    public String getBiomeMode() {
        return this.biomeMode;
    }

    @Override
    public boolean getBorderMode() {
        return this.borderMode;
    }

    @Override
    public boolean getCircular() {
        return this.circular;
    }

    @Override
    public String getConfigCategory() {
        return this.configCategory;
    }

    @Override
    public String getCoordsMode() {
        return this.coordsMode;
    }

    @Override
    public String[] getCoordsModeStringArray() {
        return coordsModeStringArray;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public double getHeightPercent() {
        return this.heightPercent;
    }

    @Override
    public String getMapPosCategory() {
        return this.mapPosCategory;
    }

    @Override
    public int getMarkerSize() {
        return this.markerSize;
    }

    @Override
    public int getPlayerArrowSize() {
        return this.playerArrowSize;
    }

    @Override
    public boolean getRotate() {
        return this.rotate;
    }

    @Override
    public int getTrailMarkerSize() {
        return this.trailMarkerSize;
    }

    @Override
    public double getWidthPercent() {
        return this.widthPercent;
    }

    @Override
    public double getXPos() {
        return this.xPos;
    }

    @Override
    public double getYPos() {
        return this.yPos;
    }

    public void loadConfig() {
        this.playerArrowSize = ConfigurationHandler.configuration.getInt("playerArrowSize", this.configCategory, this.playerArrowSizeDef, 1, 20, "", "mw.config.map.playerArrowSize");
        this.markerSize = ConfigurationHandler.configuration.getInt("markerSize", this.configCategory, this.markerSizeDef, 1, 20, "", "mw.config.map.markerSize");
        this.alphaPercent = ConfigurationHandler.configuration.getInt("alphaPercent", this.configCategory, this.alphaPercentDef, 0, 100, "", "mw.config.map.alphaPercent");
        this.trailMarkerSize = Math.max(1, this.markerSize - 1);
        this.xPos = ConfigurationHandler.configuration.get(this.mapPosCategory, "xPos", this.xPosDef, " [range: 0.0 ~ 100.0, default: " + this.xPosDef + "]", 0.0, 100.0).setLanguageKey("mw.config.map.xPos").setConfigEntryClass(ModGuiConfig.ModNumberSliderEntry.class).getDouble();
        this.yPos = ConfigurationHandler.configuration.get(this.mapPosCategory, "yPos", this.yPosDef, " [range: 0.0 ~ 100.0, default: " + this.yPosDef + "]", 0.0, 100.0).setLanguageKey("mw.config.map.yPos").setConfigEntryClass(ModGuiConfig.ModNumberSliderEntry.class).getDouble();
        this.heightPercent = ConfigurationHandler.configuration.get(this.mapPosCategory, "heightPercent", this.heightPercentDef, " [range: 0.0 ~ 100.0, default: " + this.heightPercentDef + "]", 0.0, 100.0).setLanguageKey("mw.config.map.heightPercent").setConfigEntryClass(ModGuiConfig.ModNumberSliderEntry.class).getDouble();
        this.widthPercent = ConfigurationHandler.configuration.get(this.mapPosCategory, "widthPercent", this.widthPercentDef, " [range: 0.0 ~ 100.0, default: " + this.widthPercentDef + "]", 0.0, 100.0).setLanguageKey("mw.config.map.widthPercent").setConfigEntryClass(ModGuiConfig.ModNumberSliderEntry.class).getDouble();
    }

    public void setDefaults() {
        ConfigurationHandler.configuration.getCategory(this.mapPosCategory).setLanguageKey("mw.config.map.ctgy.position").setConfigEntryClass(ModGuiConfigHUD.MapPosConfigEntry.class).setShowInGui(false);
    }
}

