/*
 * Decompiled with CFR 0.152.
 */
package mapwriter;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import mapwriter.tasks.Task;
import mapwriter.util.Logging;

public class BackgroundExecutor {
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private LinkedList<Task> taskQueue = new LinkedList();
    public boolean closed = false;
    private boolean doDiag = true;

    public boolean addTask(Task task) {
        if (!this.closed) {
            if (!task.CheckForDuplicate()) {
                Future<?> future = this.executor.submit(task);
                task.setFuture(future);
                this.taskQueue.add(task);
            }
            if (this.tasksRemaining() > 500 && this.doDiag) {
                this.doDiag = false;
                Logging.logError("Taskque went over 500 starting diagnostic", new Object[0]);
                this.taskLeftPerType();
                Logging.logError("End of diagnostic", new Object[0]);
            } else {
                this.doDiag = true;
            }
        } else {
            Logging.log("MwExecutor.addTask: error: cannot add task to closed executor", new Object[0]);
        }
        return this.closed;
    }

    public boolean close() {
        boolean error = true;
        try {
            this.taskLeftPerType();
            this.executor.shutdown();
            this.processRemainingTasks(50, 5);
            error = !this.executor.awaitTermination(10L, TimeUnit.SECONDS);
            error = false;
        }
        catch (InterruptedException e) {
            Logging.log("error: IO task was interrupted during shutdown", new Object[0]);
            e.printStackTrace();
        }
        this.closed = true;
        return error;
    }

    public boolean processRemainingTasks(int attempts, int delay) {
        while (this.taskQueue.size() > 0 && attempts > 0) {
            if (!this.processTaskQueue()) continue;
            try {
                Thread.sleep(delay);
            }
            catch (Exception exception) {
                // empty catch block
            }
            --attempts;
        }
        return attempts <= 0;
    }

    public boolean processTaskQueue() {
        boolean processed = false;
        Task task = this.taskQueue.poll();
        if (task != null) {
            if (task.isDone()) {
                task.printException();
                task.onComplete();
                processed = true;
            } else {
                this.taskQueue.push(task);
            }
        }
        return !processed;
    }

    public int tasksRemaining() {
        return this.taskQueue.size();
    }

    private void taskLeftPerType() {
        HashMap<String, Integer> tasksLeft = new HashMap<String, Integer>();
        for (Task task : this.taskQueue) {
            String className = task.getClass().toString();
            if (tasksLeft.containsKey(className)) {
                tasksLeft.put(className, (Integer)tasksLeft.get(className) + 1);
                continue;
            }
            tasksLeft.put(className, 1);
        }
        for (Map.Entry entry : tasksLeft.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Logging.log("waiting for %d %s to finish...", value, key);
        }
    }
}

