/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.text;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.client.MinecraftForgeClient;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.text.Span;
import vazkii.patchouli.client.book.text.Word;

public class TextLayouter {
    private final List<Word> words = new ArrayList<Word>();
    private final GuiBook gui;
    private final int pageX;
    private final int lineHeight;
    private final int pageWidth;
    private int y;
    private List<Word> linkCluster = null;
    private List<Span> spanCluster = null;
    private final List<SpanTail> pending = new ArrayList<SpanTail>();
    private int lineStart = 0;
    private int widthSoFar = 0;
    private FontRenderer font;

    public TextLayouter(GuiBook gui, int pageX, int pageY, int lineHeight, int pageWidth) {
        this.gui = gui;
        this.pageX = pageX;
        this.lineHeight = lineHeight;
        this.pageWidth = pageWidth;
        this.y = pageY;
    }

    public void layout(FontRenderer font, List<Span> spans) {
        this.font = font;
        ArrayList<Span> paragraph = new ArrayList<Span>();
        for (Span span : spans) {
            if (span.lineBreaks > 0) {
                this.layoutParagraph(paragraph);
                this.widthSoFar = 0;
                this.y += span.lineBreaks * this.lineHeight;
                paragraph.clear();
            }
            paragraph.add(span);
        }
        if (!paragraph.isEmpty()) {
            this.layoutParagraph(paragraph);
        }
    }

    private void layoutParagraph(List<Span> paragraph) {
        String text = this.toString(paragraph);
        BreakIterator iterator = BreakIterator.getLineInstance(MinecraftForgeClient.getLocale());
        iterator.setText(text);
        this.lineStart = 0;
        for (Span span : paragraph) {
            this.layoutSpan(iterator, span);
        }
        this.flush();
    }

    private void layoutSpan(BreakIterator iterator, Span span) {
        if (this.spanCluster != span.linkCluster) {
            this.linkCluster = span.linkCluster == null ? null : new ArrayList();
            this.spanCluster = span.linkCluster;
        }
        SpanTail last = new SpanTail(span, 0, this.linkCluster);
        this.widthSoFar += last.width;
        this.pending.add(last);
        while (this.widthSoFar > this.pageWidth) {
            this.breakLine(iterator);
            this.widthSoFar = 0;
            for (SpanTail pending : this.pending) {
                this.widthSoFar += pending.width;
            }
        }
    }

    private void breakLine(BreakIterator iterator) {
        int width = 0;
        int offset = 0;
        for (SpanTail pending : this.pending) {
            width += pending.width;
            offset += pending.length;
        }
        SpanTail last = this.pending.get(this.pending.size() - 1);
        width -= last.width;
        offset -= last.length;
        char[] characters = ((SpanTail)last).span.text.toCharArray();
        for (int i = last.start; i < characters.length; ++i) {
            IFormattableTextComponent tmp = new StringTextComponent(String.valueOf(characters[i])).func_230530_a_(((SpanTail)last).span.style);
            width += this.font.func_238414_a_((ITextProperties)tmp);
            if (((SpanTail)last).span.bold) {
                ++width;
            }
            if (width <= this.pageWidth) continue;
            int overflowOffset = this.lineStart + offset + i - last.start;
            int breakOffset = overflowOffset + 1;
            if (!Character.isWhitespace(characters[i])) {
                breakOffset = iterator.preceding(breakOffset);
            }
            if (breakOffset <= this.lineStart) {
                breakOffset = overflowOffset - 1;
            }
            this.breakLine(breakOffset);
            return;
        }
        this.flush();
        this.y += this.lineHeight;
    }

    private String toString(List<Span> paragraph) {
        StringBuilder result = new StringBuilder();
        for (Span span : paragraph) {
            result.append(span.text);
        }
        return result.toString();
    }

    public void flush() {
        if (this.pending.isEmpty()) {
            return;
        }
        int x = this.pageX;
        for (SpanTail pending : this.pending) {
            this.words.add(pending.position(this.gui, x, this.y, pending.length));
            x += pending.width;
        }
        this.pending.clear();
    }

    private void breakLine(int textOffset) {
        int offset = this.lineStart;
        int x = this.pageX;
        for (int index = 0; index < this.pending.size(); ++index) {
            SpanTail span = this.pending.get(index);
            if (offset + span.length < textOffset) {
                this.words.add(span.position(this.gui, x, this.y, span.length));
                offset += span.length;
                x += span.width;
                continue;
            }
            this.words.add(span.position(this.gui, x, this.y, textOffset - offset));
            this.pending.set(index, span.tail(textOffset - offset));
            break;
        }
        for (int i = index - 1; i >= 0; --i) {
            this.pending.remove(i);
        }
        this.lineStart = textOffset;
        this.y += this.lineHeight;
    }

    public List<Word> getWords() {
        return this.words;
    }

    private class SpanTail {
        private final Span span;
        private final int start;
        private final int width;
        private final List<Word> cluster;
        private final int length;

        public SpanTail(Span span, int start, List<Word> cluster) {
            this.span = span;
            this.start = start;
            this.width = TextLayouter.this.font.func_238414_a_((ITextProperties)span.styledSubstring(start)) + span.spacingLeft + span.spacingRight;
            this.cluster = cluster;
            this.length = span.text.length() - start;
        }

        public Word position(GuiBook gui, int x, int y, int length) {
            Word result = new Word(gui, this.span, this.span.styledSubstring(this.start, this.start + length), x += this.span.spacingLeft, y, this.width, this.cluster);
            if (this.cluster != null) {
                this.cluster.add(result);
            }
            return result;
        }

        public SpanTail tail(int offset) {
            return new SpanTail(this.span, this.start + offset, this.cluster);
        }
    }
}

