/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookCategory;
import vazkii.patchouli.client.book.gui.GuiBookHistory;
import vazkii.patchouli.client.book.gui.GuiBookIndex;
import vazkii.patchouli.client.book.gui.GuiBookWriter;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookAdvancements;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookEdit;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookHistory;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookResize;
import vazkii.patchouli.client.book.gui.button.GuiButtonCategory;
import vazkii.patchouli.client.book.gui.button.GuiButtonIndex;
import vazkii.patchouli.client.gui.GuiAdvancementsExt;
import vazkii.patchouli.common.book.Book;

public class GuiBookLanding
extends GuiBook {
    BookTextRenderer text;
    int loadedCategories = 0;

    public GuiBookLanding(Book book) {
        super(book, (ITextComponent)new TranslationTextComponent(book.name));
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.text = new BookTextRenderer(this, I18n.func_135052_a((String)this.book.landingText, (Object[])new Object[0]), 15, 43);
        boolean disableBar = !this.book.showProgress || !this.book.advancementsEnabled();
        int x = this.bookLeft + (disableBar ? 25 : 20);
        int y = this.bookTop + 180 - (disableBar ? 25 : 62);
        int dist = 15;
        int pos = 0;
        if (this.maxScale > 2) {
            this.func_230480_a_(new GuiButtonBookResize(this, x + pos++ * dist, y, true, this::handleButtonResize));
        }
        this.func_230480_a_(new GuiButtonBookHistory(this, x + pos++ * dist, y, this::handleButtonHistory));
        if (this.book.advancementsTab != null) {
            this.func_230480_a_(new GuiButtonBookAdvancements(this, x + pos++ * dist, y, this::handleButtonAdvancements));
        }
        if (Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            this.func_230480_a_(new GuiButtonBookEdit(this, x + pos++ * dist, y, this::handleButtonEdit));
        }
        int i = 0;
        ArrayList<BookCategory> categories = new ArrayList<BookCategory>(this.book.contents.categories.values());
        Collections.sort(categories);
        for (BookCategory category : categories) {
            if (category.getParentCategory() != null || category.shouldHide()) continue;
            this.addCategoryButton(i, category);
            ++i;
        }
        this.addCategoryButton(i, null);
        this.loadedCategories = i + 1;
    }

    void addCategoryButton(int i, BookCategory category) {
        int x = 151 + i % 4 * 24;
        int y = 43 + i / 4 * 24;
        if (category == null) {
            this.func_230480_a_(new GuiButtonIndex(this, x, y, this::handleButtonIndex));
        } else {
            this.func_230480_a_(new GuiButtonCategory(this, x, y, category, this::handleButtonCategory));
        }
    }

    @Override
    void drawForegroundElements(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.text.render(ms, mouseX, mouseY);
        this.drawCenteredStringNoShadow(ms, I18n.func_135052_a((String)"patchouli.gui.lexicon.categories", (Object[])new Object[0]), 199, 18, this.book.headerColor);
        int topSeparator = 30;
        int bottomSeparator = topSeparator + 25 + 24 * ((this.loadedCategories - 1) / 4 + 1);
        this.drawHeader(ms);
        GuiBookLanding.drawSeparator(ms, this.book, 141, topSeparator);
        if (this.loadedCategories <= 16) {
            GuiBookLanding.drawSeparator(ms, this.book, 141, bottomSeparator);
        }
        if (this.book.contents.isErrored()) {
            int x = 199;
            int y = bottomSeparator + 12;
            this.drawCenteredStringNoShadow(ms, I18n.func_135052_a((String)"patchouli.gui.lexicon.loading_error", (Object[])new Object[0]), x, y, 0xFF0000);
            this.drawCenteredStringNoShadow(ms, I18n.func_135052_a((String)"patchouli.gui.lexicon.loading_error_hover", (Object[])new Object[0]), x, y + 10, 0x777777);
            if (this.isMouseInRelativeRange(mouseX, mouseY, x -= 58, y -= 4, 116, 20)) {
                this.makeErrorTooltip();
            }
        }
        this.drawProgressBar(ms, this.book, mouseX, mouseY, e -> true);
    }

    void drawHeader(MatrixStack ms) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiBookLanding.drawFromTexture(ms, this.book, -8, 12, 0, 180, 140, 31);
        int color = this.book.nameplateColor;
        this.field_230712_o_.func_238422_b_(ms, this.book.getBookItem().func_200301_q().func_241878_f(), 13.0f, 16.0f, color);
        IFormattableTextComponent toDraw = this.book.getSubtitle().func_230530_a_(this.book.getFontStyle());
        this.field_230712_o_.func_238422_b_(ms, toDraw.func_241878_f(), 24.0f, 24.0f, color);
    }

    void makeErrorTooltip() {
        ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>();
        for (Throwable e = this.book.contents.getException(); e != null; e = e.getCause()) {
            String msg = e.getMessage();
            if (msg == null || msg.isEmpty()) continue;
            lines.add((ITextComponent)new StringTextComponent(e.getMessage()));
        }
        if (!lines.isEmpty()) {
            lines.add((ITextComponent)new TranslationTextComponent("patchouli.gui.lexicon.loading_error_log").func_240699_a_(TextFormatting.GREEN));
            this.setTooltip(lines);
        }
    }

    @Override
    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        return this.text.click(mouseX, mouseY, mouseButton) || super.mouseClickedScaled(mouseX, mouseY, mouseButton);
    }

    public void handleButtonIndex(Button button) {
        this.displayLexiconGui(new GuiBookIndex(this.book), true);
    }

    public void handleButtonCategory(Button button) {
        this.displayLexiconGui(new GuiBookCategory(this.book, ((GuiButtonCategory)button).getCategory()), true);
    }

    public void handleButtonHistory(Button button) {
        this.displayLexiconGui(new GuiBookHistory(this.book), true);
    }

    public void handleButtonConfig(Button button) {
    }

    public void handleButtonAdvancements(Button button) {
        this.getMinecraft().func_147108_a((Screen)new GuiAdvancementsExt(this.getMinecraft().field_71439_g.field_71174_a.func_191982_f(), this, this.book.advancementsTab));
    }

    public void handleButtonEdit(Button button) {
        if (GuiBookLanding.func_231173_s_()) {
            long time = System.currentTimeMillis();
            this.book.reloadContentsAndExtensions();
            this.book.reloadLocks(false);
            this.displayLexiconGui(new GuiBookLanding(this.book), false);
            this.getMinecraft().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("patchouli.gui.lexicon.reloaded", new Object[]{System.currentTimeMillis() - time}), Util.field_240973_b_);
        } else {
            this.displayLexiconGui(new GuiBookWriter(this.book), true);
        }
    }

    public void handleButtonResize(Button button) {
        PersistentData.data.bookGuiScale = PersistentData.data.bookGuiScale >= this.maxScale ? 0 : Math.max(2, PersistentData.data.bookGuiScale + 1);
        PersistentData.save();
        this.displayLexiconGui(this, false);
    }
}

