/*
 * Decompiled with CFR 0.152.
 */
package me.thonk.croptopia;

import java.util.ArrayList;
import java.util.HashMap;
import me.thonk.croptopia.BiomeLootCondition;
import me.thonk.croptopia.Composter;
import me.thonk.croptopia.DamageDurabilityRecipe;
import me.thonk.croptopia.blocks.CroptopiaCropBlock;
import me.thonk.croptopia.blocks.LeafCropBlock;
import me.thonk.croptopia.config.Config;
import me.thonk.croptopia.dependencies.Patchouli;
import me.thonk.croptopia.events.BiomeModification;
import me.thonk.croptopia.events.BlockBreakEvent;
import me.thonk.croptopia.events.Harvest;
import me.thonk.croptopia.events.LootTableModification;
import me.thonk.croptopia.items.SeedItem;
import me.thonk.croptopia.registry.BlockRegistry;
import me.thonk.croptopia.registry.ItemRegistry;
import me.thonk.croptopia.registry.LeavesRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.entity.EntityType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventListenerHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="croptopia")
public class CroptopiaForge {
    private static final Logger LOGGER = LogManager.getLogger();
    public static ArrayList<Block> cropBlocks = new ArrayList();
    public static ArrayList<Block> leafBlocks = new ArrayList();
    public static ArrayList<SeedItem> seeds = new ArrayList();
    public static LootConditionType BIOME_CHECK;
    public static DamageDurabilityRecipe.DamageDurabilitySerializer DAMAGE_DURABILITY;
    public static Config config;
    public static Patchouli patchouli;
    public static ItemGroup CROPTOPIA_ITEM_GROUP;

    public CroptopiaForge() {
        config = new Config();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(config::initConfig);
        MinecraftForge.EVENT_BUS.register((Object)new BiomeModification());
        MinecraftForge.EVENT_BUS.register((Object)new LootTableModification());
        MinecraftForge.EVENT_BUS.register((Object)new Harvest());
        MinecraftForge.EVENT_BUS.register((Object)new BlockBreakEvent());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CroptopiaForge.config.config);
        EventListenerHelper.getListenerList(PlayerInteractEvent.RightClickBlock.class);
        CROPTOPIA_ITEM_GROUP = new ItemGroup("croptopia"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ItemRegistry.onion);
            }
        };
    }

    private void setup(FMLCommonSetupEvent event) {
        Composter.init();
        BIOME_CHECK = CroptopiaForge.registerLootCondition("biome_check", new BiomeLootCondition.Serializer());
        patchouli = new Patchouli();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        cropBlocks.forEach(block -> RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228641_d_()));
        BlockColors colors = ((Minecraft)event.getMinecraftSupplier().get()).func_184125_al();
        colors.func_186722_a((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)world, (BlockPos)pos) : FoliageColors.func_77468_c(), leafBlocks.toArray(new Block[0]));
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    public static ResourceLocation createIdentifier(String name) {
        return new ResourceLocation("croptopia", name);
    }

    public static Item registerItem(RegistryEvent.Register<Item> itemRegister, String itemName, Item item) {
        item.setRegistryName(CroptopiaForge.createIdentifier(itemName));
        itemRegister.getRegistry().register((IForgeRegistryEntry)item);
        if (item instanceof BlockNamedItem) {
            ((BlockNamedItem)item).func_195946_a(Item.field_179220_a, item);
        }
        if (item instanceof SeedItem) {
            CroptopiaCropBlock block = (CroptopiaCropBlock)((SeedItem)item).func_179223_d();
            block.setSeed(item);
        }
        if (item instanceof SeedItem) {
            seeds.add((SeedItem)item);
        }
        return item;
    }

    public static Block registerBlock(String blockName, Block block) {
        cropBlocks.add(block);
        if (block instanceof LeafCropBlock || block instanceof LeavesBlock) {
            leafBlocks.add(block);
        }
        block.setRegistryName(CroptopiaForge.createIdentifier(blockName));
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        return block;
    }

    public static LootConditionType registerLootCondition(String id, ILootSerializer<? extends ILootCondition> serializer) {
        return (LootConditionType)Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)new ResourceLocation("croptopia", id), (Object)new LootConditionType(serializer));
    }

    public static <S extends IRecipeSerializer<T>, T extends IRecipe<?>> S registerSerializer(String id, S serializer) {
        serializer.setRegistryName(new ResourceLocation("croptopia", id));
        ForgeRegistries.RECIPE_SERIALIZERS.register(serializer);
        return serializer;
    }

    public static AbstractBlock.Properties createCropSettings() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_222472_s);
    }

    public static AbstractBlock.Properties createSaplingSettings() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c);
    }

    public static LeafCropBlock createLeavesBlock() {
        return new LeafCropBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_222472_s).func_226896_b_().func_235827_a_(CroptopiaForge::canSpawnOnLeaves).func_235842_b_(CroptopiaForge::never).func_235847_c_(CroptopiaForge::never));
    }

    public static LeavesBlock createRegularLeavesBlock() {
        return new LeavesBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_200947_a(SoundType.field_222472_s).func_226896_b_().func_235827_a_(CroptopiaForge::canSpawnOnLeaves).func_235842_b_(CroptopiaForge::never).func_235847_c_(CroptopiaForge::never));
    }

    private static Boolean canSpawnOnLeaves(BlockState state, IBlockReader world, BlockPos pos, EntityType<?> type) {
        return type == EntityType.field_200781_U || type == EntityType.field_200783_W;
    }

    private static boolean never(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LeavesRegistry.init();
            BlockRegistry.init();
            HashMap<Block, Block> stripMap = new HashMap<Block, Block>(AxeItem.field_203176_a);
            stripMap.put(BlockRegistry.cinnamonLog, BlockRegistry.strippedCinnamonLog);
            stripMap.put(BlockRegistry.cinnamonWood, BlockRegistry.strippedCinnamonWood);
            AxeItem.field_203176_a = stripMap;
        }

        @SubscribeEvent
        public static void onItemRegister(RegistryEvent.Register<Item> itemRegister) {
            ItemRegistry.init(itemRegister);
        }

        @SubscribeEvent
        public static void recipeRegister(RegistryEvent.Register<IRecipeSerializer<?>> register) {
            DAMAGE_DURABILITY = new DamageDurabilityRecipe.DamageDurabilitySerializer();
            DAMAGE_DURABILITY.setRegistryName("croptopia", "crafting_damage_durability");
            register.getRegistry().register((IForgeRegistryEntry)DAMAGE_DURABILITY);
        }
    }
}

