/*
 * Decompiled with CFR 0.152.
 */
package me.thonk.croptopia;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import me.thonk.croptopia.CroptopiaForge;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.biome.Biome;

public class BiomeLootCondition
implements ILootCondition {
    private final Biome.Category biomeCategory;

    private BiomeLootCondition(Biome.Category category) {
        this.biomeCategory = category;
    }

    public LootConditionType func_230419_b_() {
        return CroptopiaForge.BIOME_CHECK;
    }

    public boolean test(LootContext lootContext) {
        if (this.biomeCategory == Biome.Category.NONE) {
            return true;
        }
        Vector3d vec3d = (Vector3d)lootContext.func_216031_c(LootParameters.field_237457_g_);
        if (vec3d != null) {
            Biome biome = lootContext.func_202879_g().func_226691_t_(new BlockPos(vec3d));
            return biome.func_201856_r() == this.biomeCategory;
        }
        return false;
    }

    public static Builder builder(Biome.Category category) {
        return new Builder(category);
    }

    public static class Builder
    implements ILootCondition.IBuilder {
        private final Biome.Category biomeCategory;

        public Builder(Biome.Category biome) {
            this.biomeCategory = biome;
        }

        public ILootCondition build() {
            return new BiomeLootCondition(this.biomeCategory);
        }
    }

    public static class Serializer
    implements ILootSerializer<BiomeLootCondition> {
        public void serialize(JsonObject json, BiomeLootCondition object, JsonSerializationContext context) {
            json.addProperty("biome_category", object.biomeCategory.func_176610_l());
        }

        public BiomeLootCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            Biome.Category category = Biome.Category.func_235103_a_((String)JSONUtils.func_151200_h((JsonObject)json, (String)"biome_category"));
            return new BiomeLootCondition(category);
        }
    }
}

