/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Sorter<T> {
    private final List<T> sourceData;
    private final Map<Comparator<T>, List<T>> sortedDataMap = new HashMap<Comparator<T>, List<T>>();

    public Sorter(List<T> sourceData) {
        this.sourceData = sourceData;
    }

    public final Collection<Comparator<T>> getComparators() {
        return this.sortedDataMap.keySet();
    }

    @SafeVarargs
    public final void markDirty(Comparator<T> ... comparators) {
        if (comparators.length == 0) {
            this.sortedDataMap.clear();
        } else {
            for (Comparator<T> comparator : comparators) {
                this.sortedDataMap.remove(comparator);
            }
        }
    }

    public List<T> getSortedData(Comparator<T> comparator) {
        return this.getSortedData(comparator, false);
    }

    public List<T> getSortedData(Comparator<T> comparator, boolean descending) {
        List sortedData = this.ensureEntry(comparator);
        if (descending) {
            sortedData = Lists.reverse(sortedData);
        }
        return Collections.unmodifiableList(sortedData);
    }

    private List<T> ensureEntry(Comparator<T> comparator) {
        return this.sortedDataMap.computeIfAbsent(comparator, c -> {
            ArrayList<T> sortedData = new ArrayList<T>(this.sourceData);
            sortedData.sort((Comparator<T>)c);
            return sortedData;
        });
    }
}

