/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.util;

import com.google.common.graph.Graph;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import net.minecraft.util.math.MathHelper;

public final class MathUtil {
    private static final Random RANDOM;
    private static Random currentRandom;

    private MathUtil() {
    }

    public static int ceilDiv(int dividend, int divisor) {
        if (divisor < 0) {
            dividend = -dividend;
            divisor = -divisor;
        }
        return (dividend + divisor - 1) / divisor;
    }

    public static int ceil(int x, int multiple) {
        return MathUtil.ceilDiv(x, multiple) * multiple;
    }

    public static int hash(int ... values) {
        int hashCode = 1;
        for (int x : values) {
            hashCode = 31 * hashCode + x;
        }
        return hashCode;
    }

    public static void setRandom(Random random) {
        currentRandom = random != null ? random : RANDOM;
    }

    public static int randomRange(int min, int max) {
        if (min < max) {
            return min + currentRandom.nextInt(max - min);
        }
        if (min == max) {
            return min;
        }
        return max + currentRandom.nextInt(min - max);
    }

    public static float randomRange(float min, float max) {
        return min + currentRandom.nextFloat() * (max - min);
    }

    public static Point randomPoint(Rect bounds) {
        return new Point(MathUtil.randomRange(bounds.getLeft(), bounds.getRight()), MathUtil.randomRange(bounds.getTop(), bounds.getBottom()));
    }

    public static boolean randomChance(float probability) {
        return currentRandom.nextFloat() < probability;
    }

    public static int getHealthForDisplay(float health) {
        return MathHelper.func_76123_f((float)health);
    }

    public static <T> List<T> topologicalSort(Graph<T> graph) {
        ArrayList sortedNodes = new ArrayList(graph.nodes().size());
        HashSet unmarked = new HashSet(graph.nodes());
        while (!unmarked.isEmpty()) {
            MathUtil.topologicalSortVisit(graph, unmarked, sortedNodes, unmarked.iterator().next());
        }
        Collections.reverse(sortedNodes);
        return sortedNodes;
    }

    private static <T> void topologicalSortVisit(Graph<T> graph, Set<T> unvisited, List<T> sortedNodes, T predecessor) {
        if (!unvisited.remove(predecessor)) {
            return;
        }
        for (Object successor : graph.successors(predecessor)) {
            MathUtil.topologicalSortVisit(graph, unvisited, sortedNodes, successor);
        }
        sortedNodes.add(predecessor);
    }

    public static <T> int partition(List<? extends T> items, Predicate<T> condition) {
        int i;
        int j = items.size();
        for (i = 0; i != j; ++i) {
            while (!condition.test(items.get(i))) {
                if (++i != j) continue;
                return i;
            }
            do {
                if (i != --j) continue;
                return i;
            } while (condition.test(items.get(j)));
            Collections.swap(items, i, j);
        }
        return i;
    }

    public static <T> void splitList(Iterable<? extends T> items, Predicate<T> condition, Collection<? super T> pass, Collection<? super T> fail) {
        for (T t : items) {
            if (condition.test(t)) {
                pass.add(t);
                continue;
            }
            fail.add(t);
        }
    }

    public static String formatToPlaces(double x, int n) {
        DecimalFormat format = new DecimalFormat();
        format.setMaximumFractionDigits(n);
        return format.format(x);
    }

    static {
        currentRandom = RANDOM = new Random();
    }
}

