/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import jobicade.betterhud.element.HudElement;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldNameable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public abstract class InventoryNameQuery
implements IMessage {
    private BlockPos pos = null;

    public InventoryNameQuery() {
    }

    public InventoryNameQuery(BlockPos pos) {
        this.pos = pos;
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        this.pos = buffer.func_179259_c();
        this.fromBytes(buffer);
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        buffer.func_179255_a(this.pos);
        this.toBytes(buffer);
    }

    protected void fromBytes(PacketBuffer buf) {
    }

    protected void toBytes(PacketBuffer buf) {
    }

    public static class ClientHandler
    implements IMessageHandler<Response, IMessage> {
        public IMessage onMessage(Response message, MessageContext ctx) {
            HudElement.BLOCK_VIEWER.onNameReceived(message.getBlockPos(), message.getInventoryName());
            return null;
        }
    }

    public static class ServerHandler
    implements IMessageHandler<Request, Response> {
        public Response onMessage(Request message, MessageContext ctx) {
            TileEntity tileEntity = ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(message.getBlockPos());
            if (tileEntity != null && tileEntity instanceof IWorldNameable) {
                return new Response(message.getBlockPos(), tileEntity.func_145748_c_());
            }
            return null;
        }
    }

    public static class Response
    extends InventoryNameQuery {
        private ITextComponent name = null;

        public Response() {
        }

        public Response(BlockPos pos, ITextComponent name) {
            super(pos);
            this.name = name;
        }

        public ITextComponent getInventoryName() {
            return this.name;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
            try {
                this.name = buf.func_179258_d();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void toBytes(PacketBuffer buf) {
            buf.func_179256_a(this.name);
        }
    }

    public static class Request
    extends InventoryNameQuery {
        public Request() {
        }

        public Request(BlockPos pos) {
            super(pos);
        }
    }
}

