/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.gui;

import com.google.common.base.Predicates;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.gui.ActionCallback;
import jobicade.betterhud.gui.GuiActionButton;
import jobicade.betterhud.gui.GuiElements;
import jobicade.betterhud.gui.GuiTexturedButton;
import jobicade.betterhud.util.IGetSet;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;

public class GuiReorder
extends GuiElements {
    private final GuiScreen parent;
    private Rect toolbox;
    private GuiActionButton moveUp = new GuiTexturedButton(new Rect(20, 60, 20, 20));
    private GuiActionButton moveDown = new GuiTexturedButton(new Rect(40, 60, 20, 20));
    private GuiActionButton moveTop = new GuiTexturedButton(new Rect(60, 60, 20, 20));
    private GuiActionButton moveBottom = new GuiTexturedButton(new Rect(80, 60, 20, 20));
    private HudElement hovered;
    private HudElement selected;

    public GuiReorder(GuiScreen parent) {
        this.parent = parent;
        this.moveTop.setCallback(new ActionMove(false, HudElement.ELEMENTS.size()));
        this.moveUp.setCallback(new ActionMove(true, 1));
        this.moveDown.setCallback(new ActionMove(true, -1));
        this.moveBottom.setCallback(new ActionMove(false, -1));
        this.moveTop.setTooltip(I18n.func_135052_a((String)"betterHud.menu.moveTop", (Object[])new Object[0]));
        this.moveUp.setTooltip(I18n.func_135052_a((String)"betterHud.menu.moveUp", (Object[])new Object[0]));
        this.moveDown.setTooltip(I18n.func_135052_a((String)"betterHud.menu.moveDown", (Object[])new Object[0]));
        this.moveBottom.setTooltip(I18n.func_135052_a((String)"betterHud.menu.moveBottom", (Object[])new Object[0]));
    }

    private void select(HudElement element) {
        this.selected = element;
        Rect button = new Rect(20, 20);
        if (element != null) {
            this.toolbox = button.withHeight(button.getHeight() * 4 + 6).align(element.getLastBounds().grow(5, 0, 5, 0).getPosition(), Direction.NORTH_WEST);
            this.toolbox = this.toolbox.move(MathHelper.func_76125_a((int)this.toolbox.getX(), (int)0, (int)(BetterHud.MANAGER.getScreen().getWidth() - this.toolbox.getWidth())), MathHelper.func_76125_a((int)this.toolbox.getY(), (int)0, (int)(BetterHud.MANAGER.getScreen().getHeight() - this.toolbox.getHeight())));
        } else {
            this.toolbox = new Rect((Point)BetterHud.MANAGER.getScreen().getSize(), Point.zero());
        }
        button = button.anchor(this.toolbox, Direction.NORTH_WEST);
        this.moveTop.setBounds(button);
        button = button.withY(button.getBottom() + 2);
        this.moveUp.setBounds(button);
        button = button.withY(button.getBottom() + 2);
        this.moveDown.setBounds(button);
        this.moveBottom.setBounds(button.withY(button.getBottom() + 2));
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.field_146292_n.add(this.moveTop);
        this.field_146292_n.add(this.moveUp);
        this.field_146292_n.add(this.moveDown);
        this.field_146292_n.add(this.moveBottom);
        this.select(null);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof GuiActionButton) {
            ((GuiActionButton)button).actionPerformed();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            BetterHud.MC.func_147108_a(this.parent);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.toolbox.contains(mouseX, mouseY)) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        } else {
            this.select(this.hovered);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.hovered = GuiReorder.getHoveredElement(mouseX, mouseY, (Predicate<HudElement>)Predicates.alwaysFalse());
        for (HudElement element : HudElement.ELEMENTS) {
            Rect bounds = element.getLastBounds();
            if (bounds.isEmpty()) continue;
            GuiReorder.drawRect(bounds, element == this.hovered || element == this.selected);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private class ActionMove
    implements ActionCallback {
        boolean relative;
        int offset;

        ActionMove(boolean relative, int offset) {
            this.relative = relative;
            this.offset = offset;
        }

        @Override
        public void actionPerformed(GuiActionButton button) {
            if (this.relative) {
                List<HudElement> elements = HudElement.SORTER.getSortedData(HudElement.SortType.PRIORITY);
                int i = elements.indexOf(GuiReorder.this.selected) + this.offset;
                if (i >= 0 && i < elements.size()) {
                    IGetSet.swap(((GuiReorder)GuiReorder.this).selected.settings.priority, elements.get((int)i).settings.priority);
                    HudElement.SORTER.markDirty(HudElement.SortType.PRIORITY);
                }
            } else {
                ((GuiReorder)GuiReorder.this).selected.settings.priority.set(this.offset);
                HudElement.normalizePriority();
                HudElement.SORTER.markDirty(HudElement.SortType.PRIORITY);
            }
        }
    }
}

