/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.geom;

import java.io.Serializable;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Size;

public final class Rect
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Rect EMPTY = new Rect(0, 0, 0, 0);
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    public Rect() {
        this(0, 0, 0, 0);
    }

    public Rect(int width, int height) {
        this(0, 0, width, height);
    }

    public Rect(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rect(Point size) {
        this(Point.zero(), size);
    }

    public Rect(Point position, Size size) {
        this.x = position.getX();
        this.y = position.getY();
        this.width = size.getWidth();
        this.height = size.getHeight();
    }

    public Rect(Point least, Point most) {
        this(least, most.sub(least));
    }

    public Rect(Rect rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rect) {
            Rect rectangle = (Rect)obj;
            return this.x == rectangle.x && this.y == rectangle.y && this.width == rectangle.width && this.height == rectangle.height;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return (((31 + this.x) * 31 + this.y) * 31 + this.width) * 31 + this.height;
    }

    public String toString() {
        return String.format("%s{x: %d, y: %d, width: %d, height: %d}@%s", this.getClass().getName(), this.x, this.y, this.width, this.height, Integer.toHexString(System.identityHashCode(this)));
    }

    public static Rect empty() {
        return EMPTY;
    }

    public static Rect createPadding(int left, int top, int right, int bottom) {
        return new Rect(-left, -top, left + right, top + bottom);
    }

    public static Rect createPadding(int padding) {
        return new Rect(-padding, -padding, 2 * padding, 2 * padding);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLeft() {
        return this.x;
    }

    public int getTop() {
        return this.y;
    }

    public int getRight() {
        return this.x + this.width;
    }

    public int getBottom() {
        return this.y + this.height;
    }

    public Rect withX(int x) {
        return new Rect(x, this.y, this.width, this.height);
    }

    public Rect withY(int y) {
        return new Rect(this.x, y, this.width, this.height);
    }

    public Rect withWidth(int width) {
        return new Rect(this.x, this.y, width, this.height);
    }

    public Rect withHeight(int height) {
        return new Rect(this.x, this.y, this.width, height);
    }

    public Rect withLeft(int left) {
        return new Rect(left, this.y, this.x + this.width - left, this.height);
    }

    public Rect withTop(int top) {
        return new Rect(this.x, top, this.width, this.y + this.height - top);
    }

    public Rect withRight(int right) {
        return new Rect(this.x, this.y, right - this.x, this.height);
    }

    public Rect withBottom(int bottom) {
        return new Rect(this.x, this.y, this.width, bottom - this.y);
    }

    public Point getPosition() {
        return new Point(this.x, this.y);
    }

    public Size getSize() {
        return new Size(this.width, this.height);
    }

    public Point getLeast() {
        return new Point(this.x, this.y);
    }

    public Point getMost() {
        return new Point(this.x + this.width, this.y + this.height);
    }

    public Rect withLeast(int left, int top) {
        return new Rect(left, top, this.x + this.width - left, this.y + this.height - top);
    }

    public Rect withLeast(Point least) {
        return new Rect(least.getX(), least.getY(), this.x + this.width - least.getX(), this.y + this.height - least.getY());
    }

    public Rect withMost(int right, int bottom) {
        return new Rect(this.x, this.y, right - this.x, bottom - this.y);
    }

    public Rect withMost(Point most) {
        return new Rect(this.x, this.y, most.getX() - this.x, most.getY() - this.y);
    }

    public Rect move(int x, int y) {
        return new Rect(x, y, this.width, this.height);
    }

    public Rect move(Point position) {
        return new Rect(position.getX(), position.getY(), this.width, this.height);
    }

    public Rect resize(int width, int height) {
        return new Rect(this.x, this.y, width, height);
    }

    public Rect resize(Point size) {
        return new Rect(this.x, this.y, size.getX(), size.getY());
    }

    public Rect translate(int x, int y) {
        return new Rect(this.x + x, this.y + y, this.width, this.height);
    }

    public Rect translate(Point offset) {
        return new Rect(this.x + offset.getX(), this.y + offset.getY(), this.width, this.height);
    }

    public Rect untranslate(int x, int y) {
        return new Rect(this.x - x, this.y - y, this.width, this.height);
    }

    public Rect untranslate(Point offset) {
        return new Rect(this.x - offset.getX(), this.y - offset.getY(), this.width, this.height);
    }

    public Rect grow(int left, int top, int right, int bottom) {
        return new Rect(this.x - left, this.y - top, this.width + left + right, this.height + top + bottom);
    }

    public Rect grow(Rect padding) {
        return new Rect(this.x + padding.x, this.y + padding.y, this.width + padding.width, this.height + padding.height);
    }

    public Rect grow(int padding) {
        return new Rect(this.x - padding, this.y - padding, this.width + padding * 2, this.height + padding * 2);
    }

    public boolean contains(int x, int y) {
        return x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
    }

    public boolean contains(Point point) {
        return point.getX() >= this.x && point.getX() < this.x + this.width && point.getY() >= this.y && point.getY() < this.y + this.height;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean isNormal() {
        return this.width > 0 && this.height > 0;
    }

    public Rect normalize() {
        if (this.isNormal()) {
            return this;
        }
        int x = this.x;
        int y = this.y;
        int width = this.width;
        int height = this.height;
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        return new Rect(x, y, width, height);
    }

    public Rect union(Rect rect) {
        int x = Math.min(this.x, rect.x);
        int y = Math.min(this.y, rect.y);
        int width = Math.max(this.x + this.width, rect.x + rect.width) - x;
        int height = Math.max(this.y + this.height, rect.x + rect.height) - y;
        return new Rect(x, y, width, height);
    }

    public Rect intersection(Rect rect) {
        int x = Math.max(this.x, rect.x);
        int y = Math.max(this.y, rect.y);
        int width = Math.min(this.x + this.width, rect.x + rect.width) - x;
        int height = Math.min(this.y + this.height, rect.y + rect.height) - y;
        return new Rect(x, y, width, height);
    }

    public Point getAnchor(Direction direction) {
        return new Point(this.x + this.width * direction.getCol() / 2, this.y + this.height * direction.getRow() / 2);
    }

    public Rect align(Point anchor, Direction alignment) {
        return this.move(anchor.sub(this.move(Point.zero()).getAnchor(alignment)));
    }

    public Rect anchor(Rect container, Direction direction, boolean outside) {
        return this.align(container.getAnchor(direction), outside ? direction.mirror() : direction);
    }

    public Rect anchor(Rect container, Direction direction) {
        return this.anchor(container, direction, false);
    }

    public Rect invert() {
        return new Rect(-this.x, -this.y, -this.width, -this.height);
    }

    public Rect scale(int factor) {
        return new Rect(this.x * factor, this.y * factor, this.width * factor, this.height * factor);
    }

    public Rect scale(float xf, float yf) {
        return new Rect(Math.round((float)this.x * xf), Math.round((float)this.y * yf), Math.round((float)this.width * xf), Math.round((float)this.height * yf));
    }

    public Rect scale(Point factor) {
        return new Rect(this.x * factor.x, this.y * factor.y, this.width * factor.x, this.height * factor.y);
    }

    public Rect scale(float xf, float yf, int x, int y) {
        return new Rect(Math.round((float)(this.x - x) * xf + (float)x), Math.round((float)(this.y - y) * yf + (float)y), Math.round((float)this.width * xf), Math.round((float)this.height * yf));
    }

    public Rect scale(float xf, float yf, Point point) {
        return this.scale(xf, yf, point.x, point.y);
    }
}

