/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.geom;

import java.io.Serializable;
import jobicade.betterhud.geom.Size;
import net.minecraft.client.gui.ScaledResolution;

public class Point
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Point ZERO = new Point();
    protected final int x;
    protected final int y;

    public Point() {
        this(0, 0);
    }

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public Point(ScaledResolution resolution) {
        this.x = resolution.func_78326_a();
        this.y = resolution.func_78328_b();
    }

    public Size toSize() {
        return new Size(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Point)) {
            return false;
        }
        Point point = (Point)obj;
        return this.x == point.x && this.y == point.y;
    }

    public int hashCode() {
        return (31 + this.x) * 31 + this.y;
    }

    public String toString() {
        return String.format("%s{x: %d, y: %d}@%s", this.getClass().getName(), this.x, this.y, Integer.toHexString(System.identityHashCode(this)));
    }

    public String toPrettyString() {
        return String.format("(%d, %d)", this.x, this.y);
    }

    public static Point zero() {
        return ZERO;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point withX(int x) {
        return new Point(x, this.y);
    }

    public Point withY(int y) {
        return new Point(this.x, y);
    }

    public Point add(int x, int y) {
        return new Point(this.x + x, this.y + y);
    }

    public Point add(Point point) {
        return new Point(this.x + point.x, this.y + point.y);
    }

    public Size sub(int x, int y) {
        return new Size(this.x - x, this.y - y);
    }

    public Size sub(Point point) {
        return new Size(this.x - point.x, this.y - point.y);
    }

    public Point invert() {
        return new Point(-this.x, -this.y);
    }

    public Point scale(float factor) {
        return new Point(Math.round((float)this.x * factor), Math.round((float)this.y * factor));
    }

    public Point scale(float xf, float yf) {
        return new Point(Math.round((float)this.x * xf), Math.round((float)this.y * yf));
    }

    public Point scale(Point factor) {
        return new Point(this.x * factor.x, this.y * factor.y);
    }

    public Point scale(float xf, float yf, int x, int y) {
        return new Point(Math.round((float)(this.x - x) * xf + (float)x), Math.round((float)(this.y - y) * yf + (float)y));
    }

    public Point scale(float xf, float yf, Point point) {
        return this.scale(xf, yf, point.x, point.y);
    }
}

