/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.geom;

import java.util.HashMap;
import java.util.Map;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.GuiIngameForge;

public class LayoutManager {
    public static final int SPACER = 5;
    private final Map<Direction, Integer> corners = new HashMap<Direction, Integer>();
    private Rect screen;

    public void reset(ScaledResolution scaledResolution) {
        this.reset(new Point(scaledResolution));
    }

    public void reset(Point resolution) {
        this.screen = new Rect(resolution);
        this.corners.clear();
        GuiIngameForge.right_height = 14;
        GuiIngameForge.left_height = 14;
    }

    public Rect getScreen() {
        return this.screen;
    }

    public Rect positionBar(Rect bounds, Direction alignment, int postSpacer) {
        int offset = 0;
        int column = alignment.getCol();
        switch (column) {
            case 0: {
                offset = GuiIngameForge.left_height;
                break;
            }
            case 1: {
                offset = Math.max(GuiIngameForge.left_height, GuiIngameForge.right_height);
                break;
            }
            case 2: {
                offset = GuiIngameForge.right_height;
            }
        }
        Rect wideRect = bounds.withWidth(182).anchor(this.screen.grow(-(offset -= 9)), Direction.SOUTH, false);
        bounds = bounds.anchor(wideRect, alignment, false);
        int newHeight = offset + bounds.getHeight() + postSpacer + 9;
        if (column > 0) {
            GuiIngameForge.right_height = newHeight;
        }
        if (column < 2) {
            GuiIngameForge.left_height = newHeight;
        }
        this.corners.put(Direction.SOUTH, newHeight - 9);
        return bounds;
    }

    public Rect position(Direction corner, Rect bounds) {
        return this.position(corner, bounds, false, 5);
    }

    public Rect position(Direction corner, Rect bounds, boolean edge, int postSpacer) {
        if (corner.getRow() == 1) {
            throw new IllegalArgumentException("Vertical centering is not allowed");
        }
        int offset = this.corners.getOrDefault((Object)corner, edge ? 0 : 5);
        bounds = bounds.anchor(this.screen.grow(-5, -offset, -5, -offset), corner, false);
        int newOffset = offset + bounds.getHeight() + postSpacer;
        this.corners.put(corner, newOffset);
        if (corner == Direction.SOUTH) {
            GuiIngameForge.left_height = GuiIngameForge.right_height = newOffset + 9;
        }
        return bounds;
    }
}

