/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.geom;

import jobicade.betterhud.geom.Size;

public enum Direction {
    NORTH_WEST(0, 0),
    NORTH(0, 1),
    NORTH_EAST(0, 2),
    WEST(1, 0),
    CENTER(1, 1),
    EAST(1, 2),
    SOUTH_WEST(2, 0),
    SOUTH(2, 1),
    SOUTH_EAST(2, 2);

    private final int row;
    private final int col;
    private static Direction[][] grid;

    private Direction(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public Size scale(int factor) {
        return new Size((this.col - 1) * factor, (this.row - 1) * factor);
    }

    public static Direction get(int row, int col) {
        return grid[row][col];
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public Direction withRow(int row) {
        return Direction.get(row, this.col);
    }

    public Direction withCol(int col) {
        return Direction.get(this.row, col);
    }

    public Direction mirrorRow() {
        return Direction.get(2 - this.row, this.col);
    }

    public Direction mirrorCol() {
        return Direction.get(this.row, 2 - this.col);
    }

    public Direction mirror() {
        return Direction.get(2 - this.row, 2 - this.col);
    }

    static {
        grid = new Direction[3][3];
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; i < n; ++i) {
            Direction d;
            Direction.grid[d.row][d.col] = d = directionArray[i];
        }
    }
}

