/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.vanilla;

import java.util.List;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.vanilla.OverrideElement;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Vignette
extends OverrideElement {
    private static final ResourceLocation VIGNETTE_TEX_PATH = new ResourceLocation("textures/misc/vignette.png");
    private SettingBoolean warnings;
    private float brightness = 1.0f;

    public Vignette() {
        super("vignette");
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.warnings = new SettingBoolean("warnings").setValuePrefix("betterHud.value.visible");
        settings.add(this.warnings);
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.warnings.set(true);
    }

    @Override
    protected RenderGameOverlayEvent.ElementType getType() {
        return RenderGameOverlayEvent.ElementType.VIGNETTE;
    }

    @Override
    public boolean shouldRender(Event event) {
        return Minecraft.func_71375_t() && super.shouldRender(event);
    }

    @Override
    protected Rect render(Event event) {
        Color color;
        float warningDistance;
        WorldBorder border = BetterHud.MC.field_71441_e.func_175723_af();
        float distance = (float)border.func_177745_a((Entity)BetterHud.MC.field_71439_g);
        float f = distance < (warningDistance = (float)this.getWarningDistance(border)) ? 1.0f - distance / warningDistance : 0.0f;
        this.brightness += (MathHelper.func_76131_a((float)(1.0f - BetterHud.MC.field_71439_g.func_70013_c()), (float)0.0f, (float)1.0f) - this.brightness) / 100.0f;
        if (f > 0.0f) {
            int shade = Math.round(f * 255.0f);
            color = new Color(0, shade, shade);
        } else {
            int value = Math.round(this.brightness * 255.0f);
            color = new Color(value, value, value);
        }
        GlUtil.blendFuncSafe(GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        BetterHud.MC.func_110434_K().func_110577_a(VIGNETTE_TEX_PATH);
        GlUtil.drawRect(BetterHud.MANAGER.getScreen(), new Rect(256, 256), color);
        BetterHud.MC.func_110434_K().func_110577_a(Gui.field_110324_m);
        GlUtil.blendFuncSafe(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
        return null;
    }

    private double getWarningDistance(WorldBorder border) {
        double diameterDelta;
        double warningDistance = border.func_177748_q();
        double warningShrink = border.func_177749_o() * (double)border.func_177740_p() * 1000.0;
        if (warningShrink > warningDistance) {
            warningDistance = warningShrink;
        }
        if ((diameterDelta = Math.abs(border.func_177751_j() - border.func_177741_h())) < warningDistance) {
            warningDistance = diameterDelta;
        }
        return warningDistance;
    }
}

