/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.vanilla;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.geom.Size;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.render.Grid;
import jobicade.betterhud.render.Label;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Sidebar
extends HudElement {
    public Sidebar() {
        super("scoreboard", new SettingPosition(DirectionOptions.LEFT_RIGHT, DirectionOptions.WEST_EAST));
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
    }

    @Override
    public boolean shouldRender(Event event) {
        return this.getObjective((EntityPlayer)BetterHud.MC.field_71439_g) != null && super.shouldRender(event);
    }

    @Override
    protected Rect render(Event event) {
        ScoreObjective objective = this.getObjective((EntityPlayer)BetterHud.MC.field_71439_g);
        List<Score> scores = this.getScores(objective);
        Label title = new Label(objective.func_96678_d()).setShadow(false);
        ArrayList<Label> names = new ArrayList<Label>(scores.size());
        ArrayList<Label> values = new ArrayList<Label>(scores.size());
        Color valueColor = new Color(255, 255, 55, 55);
        for (Score score : scores) {
            String name = score.func_96653_e();
            String formattedName = ScorePlayerTeam.func_96667_a((Team)objective.func_96682_a().func_96509_i(name), (String)name);
            String points = String.valueOf(score.func_96652_c());
            names.add(new Label(formattedName).setShadow(false));
            values.add(new Label(points).setColor(valueColor).setShadow(false));
        }
        Grid namesGroup = new Grid(new Point(1, names.size()), names).setStretch(true).setCellAlignment(this.position.getContentAlignment().mirrorCol());
        Grid valuesGroup = new Grid(new Point(1, values.size()), values).setStretch(true).setCellAlignment(this.position.getContentAlignment());
        int spaceWidth = BetterHud.MC.field_71466_p.func_78263_a(' ');
        Size size = namesGroup.getPreferredSize().add(valuesGroup.getPreferredSize().getX() + spaceWidth * 2, 0);
        int tWidth = title.getPreferredSize().getWidth();
        if (tWidth > size.getWidth()) {
            size = size.withWidth(tWidth);
        }
        Rect padding = Rect.createPadding(1, BetterHud.MC.field_71466_p.field_78288_b + 1, 1, 1);
        Rect bounds = new Rect(size).grow(padding);
        bounds = !this.position.isCustom() && this.position.getDirection().getRow() == 1 ? bounds.anchor(BetterHud.MANAGER.getScreen(), this.position.getDirection()) : this.position.applyTo(bounds);
        Rect inner = bounds.grow(padding.invert());
        int titleBottom = inner.getTop() - 1;
        GlUtil.drawRect(bounds.withBottom(titleBottom), new Color(96, 0, 0, 0));
        GlUtil.drawRect(bounds.withTop(titleBottom), new Color(80, 0, 0, 0));
        title.setBounds(new Rect(title.getPreferredSize()).anchor(bounds.grow(-1), Direction.NORTH)).render();
        namesGroup.setBounds(inner).render();
        valuesGroup.setBounds(inner).render();
        return bounds;
    }

    private boolean showScore(Score score) {
        return !score.func_96653_e().startsWith("#");
    }

    private List<Score> getScores(ScoreObjective objective) {
        List scores = objective.func_96682_a().func_96534_i(objective).stream().filter(this::showScore).collect(Collectors.toCollection(ArrayList::new));
        Collections.reverse(scores);
        if (scores.size() > 15) {
            scores = scores.subList(0, 15);
        }
        return scores;
    }

    private ScoreObjective getObjective(EntityPlayer player) {
        int slot;
        Scoreboard scoreboard = player.func_96123_co();
        ScorePlayerTeam team = scoreboard.func_96509_i(BetterHud.MC.field_71439_g.func_70005_c_());
        if (team != null && (slot = team.func_178775_l().func_175746_b()) >= 0) {
            return scoreboard.func_96539_a(3 + slot);
        }
        return scoreboard.func_96539_a(1);
    }
}

