/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.vanilla;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.element.vanilla.PotionIcon;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.render.Boxed;
import jobicade.betterhud.render.Grid;
import jobicade.betterhud.util.MathUtil;
import net.minecraft.client.gui.Gui;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PotionBar
extends HudElement {
    public static final ResourceLocation INVENTORY = new ResourceLocation("textures/gui/container/inventory.png");
    private SettingBoolean showDuration;

    public PotionBar() {
        super("potionBar", new SettingPosition(DirectionOptions.X, DirectionOptions.CORNERS));
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.showDuration = new SettingBoolean("duration").setValuePrefix("betterHud.value.visible");
        settings.add(this.showDuration);
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.position.setPreset(Direction.NORTH_WEST);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRenderTick(RenderGameOverlayEvent.Pre event) {
        if (BetterHud.isEnabled() && event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS) {
            event.setCanceled(true);
        }
    }

    @Override
    public boolean shouldRender(Event event) {
        return super.shouldRender(event) && !BetterHud.MC.field_71439_g.func_70651_bq().isEmpty();
    }

    @Override
    public Rect render(Event event) {
        Boxed grid = this.getGrid();
        Rect bounds = new Rect(grid.getPreferredSize());
        bounds = this.position.isDirection(Direction.CENTER) ? bounds.align(BetterHud.MANAGER.getScreen().getAnchor(Direction.CENTER).add(5, 5), Direction.NORTH_WEST) : this.position.applyTo(bounds);
        grid.setBounds(bounds).render();
        BetterHud.MC.func_110434_K().func_110577_a(Gui.field_110324_m);
        return bounds;
    }

    private void populateEffects(List<PotionEffect> helpful, List<PotionEffect> harmful) {
        Stream<PotionEffect> source = BetterHud.MC.field_71439_g.func_70651_bq().parallelStream().filter(e -> e.func_188418_e() && e.func_188419_a().shouldRenderHUD(e));
        MathUtil.splitList(source::iterator, e -> e.func_188419_a().func_188408_i(), helpful, harmful);
        helpful.sort(Collections.reverseOrder());
        harmful.sort(Collections.reverseOrder());
    }

    private void fillRow(Grid<? super PotionIcon> grid, int row, List<PotionEffect> effects) {
        for (int i = 0; i < effects.size(); ++i) {
            grid.setCell(new Point(i, row), new PotionIcon(effects.get(i), this.showDuration.get()));
        }
    }

    private Boxed getGrid() {
        ArrayList<PotionEffect> helpful = new ArrayList<PotionEffect>();
        ArrayList<PotionEffect> harmful = new ArrayList<PotionEffect>();
        this.populateEffects(helpful, harmful);
        int rows = 0;
        if (!helpful.isEmpty()) {
            ++rows;
        }
        if (!harmful.isEmpty()) {
            ++rows;
        }
        Grid grid = new Grid(new Point(Math.max(helpful.size(), harmful.size()), rows));
        grid.setAlignment(this.position.getContentAlignment());
        grid.setGutter(new Point(1, 2));
        int row = 0;
        if (!helpful.isEmpty()) {
            this.fillRow(grid, row++, helpful);
        }
        if (!harmful.isEmpty()) {
            this.fillRow(grid, row++, harmful);
        }
        return grid;
    }
}

