/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.vanilla;

import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.vanilla.OverrideElement;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.render.Color;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PortalOverlay
extends OverrideElement {
    public PortalOverlay() {
        super("portal");
    }

    @Override
    protected RenderGameOverlayEvent.ElementType getType() {
        return RenderGameOverlayEvent.ElementType.PORTAL;
    }

    @Override
    public boolean shouldRender(Event event) {
        return super.shouldRender(event) && this.getTimeInPortal(event) > 0.0f;
    }

    private float getTimeInPortal(Event event) {
        return BetterHud.MC.field_71439_g.field_71080_cy + (BetterHud.MC.field_71439_g.field_71086_bY - BetterHud.MC.field_71439_g.field_71080_cy) * PortalOverlay.getPartialTicks(event);
    }

    @Override
    protected Rect render(Event event) {
        float timeInPortal = this.getTimeInPortal(event);
        if (timeInPortal < 1.0f) {
            timeInPortal *= timeInPortal;
            timeInPortal *= timeInPortal;
            timeInPortal = timeInPortal * 0.8f + 0.2f;
        }
        Color.WHITE.withAlpha(Math.round(timeInPortal * 255.0f)).apply();
        BetterHud.MC.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        TextureAtlasSprite texture = BetterHud.MC.func_175602_ab().func_175023_a().func_178122_a(Blocks.field_150427_aO.func_176223_P());
        Rect screen = BetterHud.MANAGER.getScreen();
        BetterHud.MC.field_71456_v.func_175175_a(0, 0, texture, screen.getWidth(), screen.getHeight());
        return null;
    }
}

