/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.vanilla;

import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.element.vanilla.OverrideElement;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Hotbar
extends OverrideElement {
    public Hotbar() {
        super("hotbar", new SettingPosition(DirectionOptions.TOP_BOTTOM, DirectionOptions.NONE));
        this.position.setEdge(true).setPostSpacer(2);
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.position.setPreset(Direction.SOUTH);
    }

    @Override
    protected RenderGameOverlayEvent.ElementType getType() {
        return RenderGameOverlayEvent.ElementType.HOTBAR;
    }

    @Override
    public boolean shouldRender(Event event) {
        return !GuiIngameForge.renderHotbar && super.shouldRender(event);
    }

    @Override
    protected Rect render(Event event) {
        Rect barTexture = new Rect(182, 22);
        Rect bounds = this.position.applyTo(new Rect(barTexture));
        BetterHud.MC.func_110434_K().func_110577_a(BetterHud.WIDGETS);
        GlUtil.drawRect(bounds, barTexture);
        Rect slot = bounds.grow(-3).withWidth(16);
        float partialTicks = Hotbar.getPartialTicks(event);
        int i = 0;
        while (i < 9) {
            if (i == BetterHud.MC.field_71439_g.field_71071_by.field_70461_c) {
                BetterHud.MC.func_110434_K().func_110577_a(BetterHud.WIDGETS);
                GlUtil.drawRect(slot.grow(4), new Rect(0, 22, 24, 24));
            }
            GlUtil.renderHotbarItem(slot, (ItemStack)BetterHud.MC.field_71439_g.field_71071_by.field_70462_a.get(i), partialTicks);
            ++i;
            slot = slot.translate(Direction.EAST.scale(20));
        }
        BetterHud.MC.func_110434_K().func_110577_a(Gui.field_110324_m);
        return bounds;
    }
}

