/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.vanilla;

import java.util.List;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.element.vanilla.OverrideElement;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.util.GlUtil;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Experience
extends OverrideElement {
    private SettingBoolean hideMount;

    public Experience() {
        super("experience", new SettingPosition(DirectionOptions.BAR, DirectionOptions.NORTH_SOUTH));
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.hideMount = new SettingBoolean("hideMount");
        settings.add(this.hideMount);
    }

    @Override
    protected RenderGameOverlayEvent.ElementType getType() {
        return RenderGameOverlayEvent.ElementType.EXPERIENCE;
    }

    @Override
    public boolean shouldRender(Event event) {
        return super.shouldRender(event) && BetterHud.MC.field_71442_b.func_78755_b() && (this.hideMount.get() == false || !BetterHud.MC.field_71439_g.func_110317_t());
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.settings.priority.set(1);
        this.position.setPreset(Direction.SOUTH);
    }

    @Override
    protected Rect render(Event event) {
        Rect bgTexture = new Rect(0, 64, 182, 5);
        Rect fgTexture = new Rect(0, 69, 182, 5);
        Rect barRect = new Rect(bgTexture);
        barRect = !this.position.isCustom() && this.position.getDirection() == Direction.SOUTH ? BetterHud.MANAGER.position(Direction.SOUTH, barRect, false, 1) : this.position.applyTo(barRect);
        GlUtil.drawTexturedProgressBar(barRect.getPosition(), bgTexture, fgTexture, BetterHud.MC.field_71439_g.field_71106_cc, Direction.EAST);
        if (BetterHud.MC.field_71439_g.field_71068_ca > 0) {
            String numberText = String.valueOf(BetterHud.MC.field_71439_g.field_71068_ca);
            Point numberPosition = new Rect(GlUtil.getStringSize(numberText)).anchor(barRect.grow(6), this.position.getContentAlignment().mirrorRow()).getPosition();
            GlUtil.drawBorderedString(numberText, numberPosition.getX(), numberPosition.getY(), new Color(128, 255, 32));
        }
        return barRect;
    }
}

