/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.text;

import java.util.List;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingColor;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.render.Grid;
import jobicade.betterhud.render.Label;
import jobicade.betterhud.util.GlUtil;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class TextElement
extends HudElement {
    private SettingColor color;
    protected boolean border = false;

    public TextElement(String name) {
        this(name, new SettingPosition(DirectionOptions.CORNERS, DirectionOptions.CORNERS));
    }

    public TextElement(String name, SettingPosition position) {
        super(name, position);
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.color = new SettingColor("color");
        settings.add(this.color);
    }

    public Color getColor() {
        return this.color.get();
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.position.setPreset(Direction.NORTH_EAST);
        this.color.set(Color.WHITE);
    }

    protected Rect getPadding() {
        return this.border ? Rect.createPadding(5) : Rect.empty();
    }

    protected Rect getMargin() {
        return Rect.empty();
    }

    protected Rect moveRect(Rect bounds) {
        return this.position.applyTo(bounds);
    }

    @Override
    public Rect render(Event event) {
        List<String> text = this.getText();
        return text == null || text.isEmpty() ? null : this.render(event, text);
    }

    protected Rect render(Event event, List<String> text) {
        Grid<Label> grid = new Grid(new Point(1, text.size())).setGutter(new Point(2, 2));
        Direction contentAlignment = this.position.getContentAlignment();
        if (contentAlignment != null) {
            grid.setCellAlignment(contentAlignment);
        }
        for (int i = 0; i < text.size(); ++i) {
            grid.setCell(new Point(0, i), new Label(text.get(i)).setColor(this.color.get()));
        }
        Rect padding = this.getPadding();
        Rect margin = this.getMargin();
        Rect bounds = this.moveRect(new Rect(grid.getPreferredSize().add(padding.getSize()).add(margin.getSize())));
        this.drawBorder(bounds, padding, margin);
        grid.setBounds(bounds.grow(margin.grow(padding).invert())).render();
        this.drawExtras(bounds);
        return bounds;
    }

    protected void drawBorder(Rect bounds, Rect padding, Rect margin) {
        if (this.border) {
            GlUtil.drawRect(bounds.grow(margin.invert()), Color.TRANSLUCENT);
        }
    }

    protected abstract List<String> getText();

    protected void drawExtras(Rect bounds) {
    }
}

