/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.text;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Legend;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.element.settings.SettingSlider;
import jobicade.betterhud.element.text.TextElement;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.geom.Size;
import jobicade.betterhud.render.Grid;
import jobicade.betterhud.render.Label;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Coordinates
extends TextElement {
    private SettingBoolean spaced;
    private SettingSlider decimalPlaces;

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.position.setPreset(Direction.NORTH);
        this.spaced.set(true);
        this.decimalPlaces.set(0);
        this.settings.priority.set(-2);
    }

    public Coordinates() {
        super("coordinates", new SettingPosition(DirectionOptions.TOP_BOTTOM, DirectionOptions.NONE));
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        settings.add(new Legend("misc"));
        this.spaced = new SettingBoolean("spaced");
        settings.add(this.spaced);
        this.decimalPlaces = new SettingSlider("precision", 0.0, 5.0, 1.0).setUnlocalizedValue("betterHud.value.places");
        settings.add(this.decimalPlaces);
    }

    @Override
    public Rect render(Event event, List<String> text) {
        if (!this.spaced.get().booleanValue() || !this.position.isDirection(Direction.NORTH) && !this.position.isDirection(Direction.SOUTH)) {
            return super.render(event, text);
        }
        Grid grid = new Grid(new Point(3, 1), text.stream().map(Label::new).collect(Collectors.toList())).setCellAlignment(this.position.getDirection()).setGutter(new Point(5, 5));
        Size size = grid.getPreferredSize();
        if (size.getX() < 150) {
            size = size.withX(150);
        }
        Rect bounds = BetterHud.MANAGER.position(this.position.getDirection(), new Rect(size));
        grid.setBounds(bounds).render();
        return bounds;
    }

    @Override
    protected List<String> getText() {
        DecimalFormat format = new DecimalFormat();
        format.setMaximumFractionDigits(this.decimalPlaces.get().intValue());
        String x = format.format(BetterHud.MC.field_71439_g.field_70165_t);
        String y = format.format(BetterHud.MC.field_71439_g.field_70163_u);
        String z = format.format(BetterHud.MC.field_71439_g.field_70161_v);
        if (this.spaced.get().booleanValue()) {
            x = I18n.func_135052_a((String)"betterHud.hud.x", (Object[])new Object[]{x});
            y = I18n.func_135052_a((String)"betterHud.hud.y", (Object[])new Object[]{y});
            z = I18n.func_135052_a((String)"betterHud.hud.z", (Object[])new Object[]{z});
            return Arrays.asList(x, y, z);
        }
        return Arrays.asList(I18n.func_135052_a((String)"betterHud.hud.xyz", (Object[])new Object[]{x, y, z}));
    }
}

