/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.text;

import java.util.ArrayList;
import java.util.List;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.settings.Legend;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.text.TextElement;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class Connection
extends TextElement {
    private SettingBoolean playerCount;
    private SettingBoolean showIp;
    private SettingBoolean latency;
    private String ip = "localServer";

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.playerCount.set(true);
        this.showIp.set(true);
        this.latency.set(true);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public Connection() {
        super("connection");
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        settings.add(new Legend("misc"));
        this.playerCount = new SettingBoolean("playerCount").setValuePrefix("betterHud.value.visible");
        settings.add(this.playerCount);
        this.showIp = new SettingBoolean("showIp");
        settings.add(this.showIp);
        this.latency = new SettingBoolean("latency");
        settings.add(this.latency);
    }

    @SubscribeEvent
    public void onConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.ip = !event.isLocal() ? event.getManager().func_74430_c().toString() : "localServer";
    }

    @Override
    protected List<String> getText() {
        NetworkPlayerInfo info;
        ArrayList<String> toRender = new ArrayList<String>(3);
        if (this.playerCount.get().booleanValue()) {
            int players = BetterHud.MC.func_147114_u().func_175106_d().size();
            String conn = I18n.func_135052_a((String)(players != 1 ? "betterHud.hud.players" : "betterHud.hud.player"), (Object[])new Object[]{players});
            toRender.add(conn);
        }
        if (this.showIp.get().booleanValue()) {
            toRender.add(I18n.func_135052_a((String)(this.ip.equals("localServer") ? "betterHud.hud.localServer" : "betterHud.hud.ip"), (Object[])new Object[]{this.ip}));
        }
        if (this.latency.get().booleanValue() && BetterHud.MC.func_147104_D() != null && (info = BetterHud.MC.func_147114_u().func_175102_a(BetterHud.MC.field_71439_g.func_110124_au())) != null) {
            int ping = info.func_178853_c();
            toRender.add(I18n.func_135052_a((String)"betterHud.hud.ping", (Object[])new Object[]{ping}));
        }
        return toRender;
    }
}

