/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.text;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Legend;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.settings.SettingChoose;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.element.text.TextElement;
import jobicade.betterhud.geom.Direction;

public abstract class Clock
extends TextElement {
    private SettingBoolean twentyFour;
    private SettingBoolean showSeconds;
    private SettingBoolean fullYear;
    private SettingChoose dateType;
    private static final String[] dateFormats = new String[]{"dd/MM/yy", "MM/dd/yy", "yy/MM/dd"};
    private static final String[] dateFormatsFull = new String[]{"dd/MM/yyyy", "MM/dd/yyyy", "yyyy/MM/dd"};

    public Clock(String name) {
        super(name, new SettingPosition(DirectionOptions.CORNERS, DirectionOptions.WEST_EAST));
        this.border = true;
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        settings.add(new Legend("misc"));
        this.twentyFour = new SettingBoolean("24hr");
        settings.add(this.twentyFour);
        this.showSeconds = new SettingBoolean("showSeconds").setValuePrefix("betterHud.value.visible");
        settings.add(this.showSeconds);
        this.dateType = new SettingChoose("dateType", "dmy", "mdy", "ymd");
        settings.add(this.dateType);
        this.fullYear = new SettingBoolean("fullYear").setValuePrefix("betterHud.value.visible");
        settings.add(this.fullYear);
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.position.setPreset(Direction.NORTH_EAST);
        this.twentyFour.set(false);
        this.showSeconds.set(false);
        this.dateType.setIndex(1);
        this.fullYear.set(true);
        this.settings.priority.set(-1);
    }

    protected DateFormat getTimeFormat() {
        StringBuilder format = new StringBuilder();
        format.append("HH:mm");
        if (this.showSeconds.get().booleanValue()) {
            format.append(":ss");
        }
        if (!this.twentyFour.get().booleanValue()) {
            format.append(" a");
            format.replace(0, 2, "hh");
        }
        return new SimpleDateFormat(format.toString());
    }

    protected DateFormat getDateFormat() {
        return new SimpleDateFormat((this.fullYear.get() != false ? dateFormatsFull : dateFormats)[this.dateType.getIndex()]);
    }

    @Override
    protected List<String> getText() {
        Date date = this.getDate();
        return Arrays.asList(this.getTimeFormat().format(date), this.getDateFormat().format(date));
    }

    protected abstract Date getDate();
}

