/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.settings;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingAlignable;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.gui.GuiActionButton;
import jobicade.betterhud.gui.GuiElementSettings;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;

public class SettingDirection
extends SettingAlignable<Direction> {
    private GuiActionButton[] toggles = new GuiActionButton[9];
    private Rect bounds;
    private boolean horizontal = false;
    private final DirectionOptions options;
    private Direction value;

    public SettingDirection(String name, Direction alignment) {
        this(name, alignment, DirectionOptions.ALL);
    }

    public SettingDirection(String name, Direction alignment, DirectionOptions options) {
        super(name, alignment);
        this.options = options;
    }

    public SettingDirection setHorizontal() {
        this.horizontal = true;
        this.setAlignment(Direction.WEST);
        return this;
    }

    @Override
    protected int getAlignmentWidth() {
        return this.horizontal ? 150 : 240;
    }

    @Override
    public SettingAlignable<Direction> setAlignment(Direction alignment) {
        if (!this.horizontal) {
            return super.setAlignment(alignment);
        }
        return this;
    }

    @Override
    public void getGuiParts(List<Gui> parts, Map<Gui, Setting<?>> callbacks, Rect bounds) {
        this.bounds = bounds;
        Rect radios = new Rect(60, 60).anchor(bounds, this.horizontal ? Direction.WEST : Direction.SOUTH);
        Rect radio = new Rect(20, 20);
        for (Direction direction : Direction.values()) {
            GuiActionButton button = new GuiActionButton("").setId(direction.ordinal()).setBounds(radio.anchor(radios, direction));
            parts.add((Gui)button);
            callbacks.put((Gui)button, this);
            this.toggles[direction.ordinal()] = button;
        }
    }

    @Override
    protected Point getSize() {
        return this.horizontal ? new Point(150, 60) : new Point(60, 65 + BetterHud.MC.field_71466_p.field_78288_b);
    }

    private String getText() {
        return this.horizontal ? this.getLocalizedName() + ": " + SettingDirection.localizeDirection(this.value) : this.getLocalizedName();
    }

    @Override
    public void actionPerformed(GuiElementSettings gui, GuiButton button) {
        this.value = Direction.values()[button.field_146127_k];
    }

    @Override
    public void updateGuiParts(Collection<Setting<?>> settings) {
        super.updateGuiParts(settings);
        boolean enabled = this.enabled();
        for (GuiActionButton button : this.toggles) {
            button.glowing = this.value != null && button.field_146127_k == this.value.ordinal();
            button.field_146124_l = button.glowing || enabled && this.options.isValid(Direction.values()[button.field_146127_k]);
        }
    }

    @Override
    public void draw() {
        String text = this.getText();
        if (this.horizontal) {
            GlUtil.drawString(text, this.bounds.withWidth(65).getAnchor(Direction.EAST), Direction.WEST, Color.WHITE);
        } else {
            GlUtil.drawString(text, this.bounds.getAnchor(Direction.NORTH), Direction.NORTH, Color.WHITE);
        }
    }

    @Override
    public String save() {
        return this.value != null ? this.value.name() : "null";
    }

    @Override
    public void load(String save) {
        try {
            this.set(Direction.valueOf(save));
        }
        catch (IllegalArgumentException e) {
            this.set(null);
        }
    }

    @Override
    public Direction get() {
        return this.value;
    }

    @Override
    public void set(Direction value) {
        if (this.options.isValid(value = (Direction)((Object)this.options.apply(value)))) {
            this.value = value;
        }
    }

    @Override
    protected boolean shouldBreak() {
        return this.horizontal || this.alignment == Direction.EAST;
    }

    public DirectionOptions getOptions() {
        return this.options;
    }

    public static String localizeDirection(Direction direction) {
        String name;
        switch (direction) {
            case NORTH_WEST: {
                name = "northWest";
                break;
            }
            case NORTH: {
                name = "north";
                break;
            }
            case NORTH_EAST: {
                name = "northEast";
                break;
            }
            case WEST: {
                name = "west";
                break;
            }
            case CENTER: {
                name = "center";
                break;
            }
            case EAST: {
                name = "east";
                break;
            }
            case SOUTH_WEST: {
                name = "southWest";
                break;
            }
            case SOUTH: {
                name = "south";
                break;
            }
            case SOUTH_EAST: {
                name = "southEast";
                break;
            }
            default: {
                name = "none";
            }
        }
        return I18n.func_135052_a((String)("betterHud.value." + name), (Object[])new Object[0]);
    }
}

