/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.settings;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingAlignable;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.gui.GuiElementSettings;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import org.apache.commons.lang3.ArrayUtils;

public class SettingChoose
extends SettingAlignable<String> {
    protected GuiButton last;
    protected GuiButton next;
    protected GuiButton backing;
    protected final String[] modes;
    private int index = 0;
    private int length;

    public SettingChoose(int length) {
        this("mode", length);
    }

    public SettingChoose(String name, int length) {
        this(name, new String[0]);
        this.length = length;
    }

    public SettingChoose(String name, String ... modes) {
        this(name, Direction.CENTER, modes);
    }

    public SettingChoose(String name, Direction alignment, String ... modes) {
        super(name, alignment);
        this.modes = modes;
        this.length = modes.length;
    }

    public void setIndex(int index) {
        if (index >= 0 && index < this.length) {
            this.index = index;
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void last() {
        int index = this.getIndex();
        if (index == 0) {
            index = this.length;
        }
        this.setIndex(--index);
    }

    public void next() {
        int index = this.getIndex() + 1;
        if (index == this.length) {
            index = 0;
        }
        this.setIndex(index);
    }

    @Override
    public void set(String value) {
        int index = ArrayUtils.indexOf((Object[])this.modes, (Object)value);
        if (index == -1) {
            index = Integer.parseUnsignedInt(value);
        }
        this.setIndex(index);
    }

    @Override
    public String get() {
        return this.index < this.modes.length ? this.modes[this.index] : String.valueOf(this.index);
    }

    @Override
    public String save() {
        return this.get();
    }

    @Override
    public void load(String save) {
        this.set(save);
    }

    @Override
    public void getGuiParts(List<Gui> parts, Map<Gui, Setting<?>> callbacks, Rect bounds) {
        this.backing = new GuiButton(2, bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), "");
        parts.add((Gui)this.backing);
        this.last = new GuiButton(0, bounds.getLeft(), bounds.getY(), 20, bounds.getHeight(), "<");
        parts.add((Gui)this.last);
        this.next = new GuiButton(1, bounds.getRight() - 20, bounds.getY(), 20, bounds.getHeight(), ">");
        parts.add((Gui)this.next);
        this.backing.field_146124_l = false;
        callbacks.put((Gui)this.last, this);
        callbacks.put((Gui)this.next, this);
    }

    protected String getUnlocalizedValue() {
        return "betterHud.value." + this.modes[this.getIndex()];
    }

    protected String getLocalizedValue() {
        int index = this.getIndex();
        if (index >= 0 && index < this.modes.length) {
            return I18n.func_135052_a((String)this.getUnlocalizedValue(), (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"betterHud.value.mode", (Object[])new Object[]{index});
    }

    @Override
    public void draw() {
        Point center = new Point(this.backing.field_146128_h + this.backing.field_146120_f / 2, this.backing.field_146129_i + this.backing.field_146121_g / 2);
        GlUtil.drawString(this.getLocalizedValue(), center, Direction.CENTER, Color.WHITE);
    }

    @Override
    public void actionPerformed(GuiElementSettings gui, GuiButton button) {
        if (button.field_146127_k == 0) {
            this.last();
        } else {
            this.next();
        }
    }

    @Override
    public void updateGuiParts(Collection<Setting<?>> settings) {
        this.last.field_146124_l = this.next.field_146124_l = this.enabled();
    }
}

