/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.settings;

import java.util.List;
import java.util.Map;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import net.minecraft.client.gui.Gui;

public abstract class SettingAlignable<T>
extends Setting<T> {
    protected Direction alignment;

    public SettingAlignable(String name, Direction alignment) {
        super(name);
        this.alignment = alignment;
    }

    public SettingAlignable<T> setAlignment(Direction alignment) {
        this.alignment = alignment;
        return this;
    }

    @Override
    public Point getGuiParts(List<Gui> parts, Map<Gui, Setting<?>> callbacks, Point origin) {
        origin = super.getGuiParts(parts, callbacks, origin);
        Rect bounds = new Rect(this.getSize());
        bounds = bounds.anchor(new Rect(this.getAlignmentWidth(), bounds.getHeight()).align(origin, Direction.NORTH), this.alignment);
        this.getGuiParts(parts, callbacks, bounds);
        return this.shouldBreak() ? origin.withY(bounds.getBottom() + 5) : null;
    }

    protected int getAlignmentWidth() {
        return 300;
    }

    protected Point getSize() {
        return new Point(this.alignment == Direction.CENTER ? 200 : 150, 20);
    }

    protected boolean shouldBreak() {
        return this.alignment != Direction.WEST;
    }

    public abstract void getGuiParts(List<Gui> var1, Map<Gui, Setting<?>> var2, Rect var3);
}

