/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.settings;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.gui.GuiElementSettings;
import jobicade.betterhud.gui.GuiOffsetChooser;
import jobicade.betterhud.gui.GuiUpDownButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;

public class SettingAbsolutePosition
extends Setting<Point> {
    public GuiTextField xBox;
    public GuiTextField yBox;
    public GuiButton pick;
    private GuiButton xUp;
    private GuiButton xDown;
    private GuiButton yUp;
    private GuiButton yDown;
    private final SettingPosition position;
    protected int x;
    protected int y;
    protected int cancelX;
    protected int cancelY;
    protected boolean isPicking = false;

    public boolean isPicking() {
        return this.isPicking;
    }

    public SettingAbsolutePosition(String name) {
        this(name, null);
    }

    public SettingAbsolutePosition(String name, SettingPosition position) {
        super(name);
        this.position = position;
    }

    @Override
    public Point getGuiParts(List<Gui> parts, Map<Gui, Setting<?>> callbacks, Point origin) {
        this.xBox = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, origin.getX() - 106, origin.getY() + 1, 80, 18);
        parts.add((Gui)this.xBox);
        this.xBox.func_146180_a(String.valueOf(this.x));
        this.yBox = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, origin.getX() + 2, origin.getY() + 1, 80, 18);
        parts.add((Gui)this.yBox);
        this.yBox.func_146180_a(String.valueOf(this.y));
        this.xUp = new GuiUpDownButton(true).setBounds(new Rect(origin.getX() - 22, origin.getY(), 0, 0)).setId(0).setRepeat();
        parts.add((Gui)this.xUp);
        this.xDown = new GuiUpDownButton(false).setBounds(new Rect(origin.getX() - 22, origin.getY() + 10, 0, 0)).setId(1).setRepeat();
        parts.add((Gui)this.xDown);
        this.yUp = new GuiUpDownButton(true).setBounds(new Rect(origin.getX() + 86, origin.getY(), 0, 0)).setId(2).setRepeat();
        parts.add((Gui)this.yUp);
        this.yDown = new GuiUpDownButton(false).setBounds(new Rect(origin.getX() + 86, origin.getY() + 10, 0, 0)).setId(3).setRepeat();
        parts.add((Gui)this.yDown);
        if (this.position != null) {
            this.pick = new GuiButton(4, origin.getX() - 100, origin.getY() + 22, 200, 20, I18n.func_135052_a((String)"betterHud.menu.pick", (Object[])new Object[0]));
            parts.add((Gui)this.pick);
            callbacks.put((Gui)this.pick, this);
        }
        callbacks.put((Gui)this.xBox, this);
        callbacks.put((Gui)this.yBox, this);
        callbacks.put((Gui)this.xUp, this);
        callbacks.put((Gui)this.xDown, this);
        callbacks.put((Gui)this.yUp, this);
        callbacks.put((Gui)this.yDown, this);
        return origin.add(0, 47);
    }

    public void updateText() {
        if (this.xBox != null && this.yBox != null) {
            this.xBox.func_146180_a(String.valueOf(this.x));
            this.yBox.func_146180_a(String.valueOf(this.y));
        }
    }

    @Override
    public void actionPerformed(GuiElementSettings gui, GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.xBox.func_146180_a(String.valueOf(++this.x));
                break;
            }
            case 1: {
                this.xBox.func_146180_a(String.valueOf(--this.x));
                break;
            }
            case 2: {
                this.yBox.func_146180_a(String.valueOf(++this.y));
                break;
            }
            case 3: {
                this.yBox.func_146180_a(String.valueOf(--this.y));
                break;
            }
            case 4: {
                BetterHud.MC.func_147108_a((GuiScreen)new GuiOffsetChooser(gui, this.position));
            }
        }
    }

    public void finishPicking() {
        this.isPicking = false;
    }

    @Override
    public void set(Point value) {
        this.x = value.getX();
        this.y = value.getY();
        this.updateText();
    }

    @Override
    public Point get() {
        return new Point(this.x, this.y);
    }

    @Override
    public String save() {
        return this.x + ", " + this.y;
    }

    @Override
    public void load(String val) {
        int comma = val.indexOf(44);
        int x = Integer.parseInt(val.substring(0, comma).trim());
        int y = Integer.parseInt(val.substring(comma + 1).trim());
        this.set(new Point(x, y));
    }

    @Override
    public void updateGuiParts(Collection<Setting<?>> settings) {
        super.updateGuiParts(settings);
        boolean enabled = this.enabled();
        this.xBox.func_146184_c(enabled);
        this.yBox.func_146184_c(enabled);
        if (this.pick != null) {
            this.pick.field_146124_l = enabled;
        }
        if (enabled) {
            try {
                this.x = Integer.parseInt(this.xBox.func_146179_b());
                this.xDown.field_146124_l = true;
                this.xUp.field_146124_l = true;
            }
            catch (NumberFormatException e) {
                this.x = 0;
                this.xDown.field_146124_l = false;
                this.xUp.field_146124_l = false;
            }
            try {
                this.y = Integer.parseInt(this.yBox.func_146179_b());
                this.yDown.field_146124_l = true;
                this.yUp.field_146124_l = true;
            }
            catch (NumberFormatException e) {
                this.y = 0;
                this.yDown.field_146124_l = false;
                this.yUp.field_146124_l = false;
            }
        } else {
            this.yDown.field_146124_l = false;
            this.yUp.field_146124_l = false;
            this.xDown.field_146124_l = false;
            this.xUp.field_146124_l = false;
        }
    }
}

