/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.settings;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import jobicade.betterhud.geom.Direction;

public enum DirectionOptions implements Function<Direction, Direction>
{
    ALL(Direction.values()){

        @Override
        public Direction apply(Direction direction) {
            return direction != null ? direction : Direction.NORTH_WEST;
        }
    }
    ,
    CORNERS(new Direction[]{Direction.NORTH_WEST, Direction.NORTH_EAST, Direction.SOUTH_WEST, Direction.SOUTH_EAST}){

        @Override
        public Direction apply(Direction direction) {
            if (direction != null) {
                return Direction.get(direction.getRow() > 1 ? 2 : 0, direction.getCol() > 1 ? 2 : 0);
            }
            return Direction.NORTH_WEST;
        }
    }
    ,
    WEST_EAST(new Direction[]{Direction.WEST, Direction.EAST}){

        @Override
        public Direction apply(Direction direction) {
            return direction != null && direction.getCol() >= 2 ? Direction.EAST : Direction.WEST;
        }
    }
    ,
    NORTH_SOUTH(new Direction[]{Direction.NORTH, Direction.SOUTH}){

        @Override
        public Direction apply(Direction direction) {
            return direction != null && direction.getRow() >= 2 ? Direction.SOUTH : Direction.NORTH;
        }
    }
    ,
    HORIZONTAL(new Direction[]{Direction.WEST, Direction.CENTER, Direction.EAST}){

        @Override
        public Direction apply(Direction direction) {
            return direction != null ? direction.withRow(1) : Direction.WEST;
        }
    }
    ,
    VERTICAL(new Direction[]{Direction.NORTH, Direction.CENTER, Direction.SOUTH}){

        @Override
        public Direction apply(Direction direction) {
            return direction != null ? direction.withCol(1) : Direction.NORTH;
        }
    }
    ,
    I(new Direction[]{Direction.NORTH_WEST, Direction.NORTH, Direction.NORTH_EAST, Direction.CENTER, Direction.SOUTH_WEST, Direction.SOUTH, Direction.SOUTH_EAST}){

        @Override
        public Direction apply(Direction direction) {
            switch (direction) {
                case WEST: {
                    return Direction.NORTH_WEST;
                }
                case EAST: {
                    return Direction.NORTH_EAST;
                }
            }
            return direction != null ? direction : Direction.NORTH_WEST;
        }
    }
    ,
    BAR(new Direction[]{Direction.NORTH_WEST, Direction.NORTH_EAST, Direction.SOUTH_WEST, Direction.SOUTH, Direction.SOUTH_EAST}){

        @Override
        public Direction apply(Direction direction) {
            if (direction == Direction.SOUTH) {
                return direction;
            }
            return (Direction)((Object)CORNERS.apply(direction));
        }
    }
    ,
    X(new Direction[]{Direction.NORTH_WEST, Direction.NORTH_EAST, Direction.CENTER, Direction.SOUTH_WEST, Direction.SOUTH_EAST}){

        @Override
        public Direction apply(Direction direction) {
            return direction == Direction.CENTER ? direction : (Direction)((Object)CORNERS.apply(direction));
        }
    }
    ,
    TOP_BOTTOM(new Direction[]{Direction.NORTH_WEST, Direction.NORTH, Direction.NORTH_EAST, Direction.SOUTH_WEST, Direction.SOUTH, Direction.SOUTH_EAST}){

        @Override
        public Direction apply(Direction direction) {
            if (direction == null) {
                return Direction.NORTH_WEST;
            }
            if (direction.getRow() == 1) {
                return direction.withRow(0);
            }
            return direction;
        }
    }
    ,
    LEFT_RIGHT(new Direction[]{Direction.NORTH_WEST, Direction.WEST, Direction.SOUTH_WEST, Direction.NORTH_EAST, Direction.EAST, Direction.SOUTH_EAST}){

        @Override
        public Direction apply(Direction direction) {
            if (direction == null) {
                return Direction.NORTH_WEST;
            }
            if (direction.getCol() == 1) {
                return direction.withCol(0);
            }
            return direction;
        }
    }
    ,
    NONE(new Direction[0]){

        @Override
        public Direction apply(Direction direction) {
            return null;
        }
    };

    private final Set<Direction> directions = EnumSet.noneOf(Direction.class);

    private DirectionOptions(Direction ... directions) {
        Collections.addAll(this.directions, directions);
    }

    public boolean isValid(Direction direction) {
        return this.directions.contains((Object)direction);
    }
}

