/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element.particles;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.element.particles.Particle;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingChoose;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.util.Tickable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class ParticleOverlay
extends HudElement
implements Tickable {
    protected SettingChoose density;
    protected final List<Particle> particles = new CopyOnWriteArrayList<Particle>();

    protected ParticleOverlay(String name) {
        super(name);
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.density = new SettingChoose("density", "sparse", "normal", "dense", "denser");
        settings.add(this.density);
    }

    protected void updateParticles() {
        this.particles.removeIf(Particle::isDead);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Tickable.Ticker.FASTER.register(this);
    }

    @Override
    public void tick() {
        if (!this.isEnabledAndSupported() || BetterHud.MC.field_71439_g == null || BetterHud.MC.field_71441_e == null) {
            return;
        }
        this.particles.forEach(Tickable::tick);
        this.updateParticles();
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.density.setIndex(1);
    }

    @Override
    public Rect render(Event event) {
        for (Particle particle : this.particles) {
            particle.render(ParticleOverlay.getPartialTicks(event));
        }
        return BetterHud.MANAGER.getScreen();
    }

    @Override
    public boolean shouldRender(Event event) {
        return !this.particles.isEmpty();
    }
}

