/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.render.Grid;
import jobicade.betterhud.render.Label;
import jobicade.betterhud.render.Quad;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SignReader
extends HudElement {
    private static final ResourceLocation SIGN_TEXTURE = new ResourceLocation("textures/entity/sign.png");

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.position.setPreset(Direction.NORTH_WEST);
    }

    public SignReader() {
        super("signReader", new SettingPosition(DirectionOptions.CORNERS, DirectionOptions.NONE));
    }

    @Override
    public boolean shouldRender(Event event) {
        return this.getSign() != null;
    }

    @Override
    public Rect render(Event event) {
        Rect bounds = this.position.applyTo(new Rect(96, 48));
        BetterHud.MC.func_110434_K().func_110577_a(SIGN_TEXTURE);
        new Quad().setTexture(new Rect(2, 2, 24, 12).scale(4.0f, 8.0f)).setBounds(bounds).render();
        List labels = Stream.of(this.getSign().field_145915_a).map(line -> new Label(line.func_150254_d()).setColor(Color.BLACK).setShadow(false)).collect(Collectors.toList());
        Grid grid = new Grid(new Point(1, labels.size()), labels);
        grid.setBounds(bounds.grow(-3)).render();
        return bounds;
    }

    private TileEntitySign getSign() {
        TileEntity tileEntity;
        RayTraceResult trace = BetterHud.MC.func_175606_aa().func_174822_a(200.0, 1.0f);
        IBlockState state = BetterHud.MC.field_71441_e.func_180495_p(trace.func_178782_a());
        if (state.func_177230_c() instanceof ITileEntityProvider && (tileEntity = BetterHud.MC.field_71441_e.func_175625_s(trace.func_178782_a())) instanceof TileEntitySign) {
            return (TileEntitySign)tileEntity;
        }
        return null;
    }
}

