/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.element.settings.SettingSlider;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.geom.Size;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.render.DefaultBoxed;
import jobicade.betterhud.render.Grid;
import jobicade.betterhud.render.Label;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.versioning.InvalidVersionSpecificationException;
import net.minecraftforge.fml.common.versioning.VersionRange;
import net.minecraftforge.items.ItemHandlerHelper;

public class PickupCount
extends HudElement {
    private SettingSlider maxStacks;
    private SettingSlider fadeAfter;
    public final List<StackNode> stacks = new CopyOnWriteArrayList<StackNode>();

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.position.setPreset(Direction.SOUTH_EAST);
        this.fadeAfter.set(0.5);
        this.maxStacks.set(11);
    }

    public PickupCount() {
        super("itemPickup", new SettingPosition(DirectionOptions.X, DirectionOptions.CORNERS));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.fadeAfter = new SettingSlider("fadeAfter", 20.0, 600.0, 20.0).setDisplayScale(0.05).setUnlocalizedValue("betterHud.hud.seconds");
        settings.add(this.fadeAfter);
        this.maxStacks = new SettingSlider("maxStacks", 1.0, 11.0, 1.0){

            @Override
            public String getDisplayValue(double scaledValue) {
                return scaledValue == this.getMaximum() ? I18n.func_135052_a((String)"betterHud.value.unlimited", (Object[])new Object[0]) : super.getDisplayValue(scaledValue);
            }
        };
        settings.add(this.maxStacks);
    }

    @Override
    public VersionRange getServerDependency() throws InvalidVersionSpecificationException {
        return VersionRange.createFromVersionSpec((String)"[1.4-beta,)");
    }

    private StackNode removeStack(ItemStack stack) {
        for (StackNode node : this.stacks) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)node.stack)) continue;
            this.stacks.remove(node);
            return node;
        }
        return null;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemPickupPlayer(PlayerEvent.ItemPickupEvent e) {
        ItemStack stack = e.getStack();
        if (stack.func_190926_b()) {
            return;
        }
        this.refreshStack(stack);
    }

    private synchronized void refreshStack(ItemStack stack) {
        StackNode node = this.removeStack(stack);
        if (node != null) {
            node.increaseStackSize(stack.func_190916_E());
        } else {
            node = new StackNode(stack);
        }
        this.stacks.add(0, node);
    }

    private synchronized List<StackNode> getStacks() {
        this.stacks.removeIf(rec$ -> ((StackNode)rec$).isDead());
        int limit = this.maxStacks.getInt();
        if (limit < 11 && limit < this.stacks.size()) {
            this.stacks.subList(limit, this.stacks.size()).clear();
        }
        return this.stacks;
    }

    @Override
    public Rect render(Event event) {
        List<StackNode> stacks = this.getStacks();
        Grid<StackNode> grid = new Grid<StackNode>(new Point(1, stacks.size()), stacks).setAlignment(this.position.getContentAlignment()).setCellAlignment(this.position.getContentAlignment());
        Rect bounds = new Rect(grid.getPreferredSize());
        bounds = this.position.isDirection(Direction.CENTER) ? bounds.align(BetterHud.MANAGER.getScreen().getAnchor(Direction.CENTER).add(5, 5), Direction.NORTH_WEST) : this.position.applyTo(bounds);
        grid.setBounds(bounds).render();
        return bounds;
    }

    private class StackNode
    extends DefaultBoxed {
        private final ItemStack stack;
        private long updateCounter;

        public StackNode(ItemStack stack) {
            this.stack = stack;
            this.updateCounter = BetterHud.MC.field_71456_v.func_73834_c();
        }

        public void increaseStackSize(int size) {
            this.stack.func_190920_e(this.stack.func_190916_E() + size);
            this.updateCounter = BetterHud.MC.field_71456_v.func_73834_c();
        }

        private Label getLabel() {
            return new Label(this.stack.func_190916_E() + " " + this.stack.func_82833_r()).setColor(Color.WHITE.withAlpha(Math.round(this.getOpacity() * 255.0f)));
        }

        private float getOpacity() {
            return 1.0f - (float)((long)BetterHud.MC.field_71456_v.func_73834_c() - this.updateCounter) / PickupCount.this.fadeAfter.get().floatValue();
        }

        private boolean isDead() {
            return this.getOpacity() <= 0.0f;
        }

        @Override
        public Size negotiateSize(Point size) {
            return this.getLabel().getPreferredSize().withHeight(16).add(21, 0);
        }

        @Override
        public void render() {
            Direction alignment = PickupCount.this.position.getContentAlignment().withRow(1);
            GlUtil.renderSingleItem(this.stack, new Rect(16, 16).anchor(this.bounds, alignment).getPosition());
            Label label = this.getLabel();
            label.setBounds(new Rect(label.getPreferredSize()).anchor(this.bounds, alignment.mirrorCol())).render();
        }
    }
}

