/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element;

import java.util.ArrayList;
import java.util.List;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.settings.Legend;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.text.TextElement;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.util.GlUtil;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ExperienceInfo
extends TextElement {
    private SettingBoolean total;
    private SettingBoolean lifetime;

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.total.set(false);
        this.lifetime.set(false);
        this.settings.priority.set(2);
    }

    public ExperienceInfo() {
        super("experienceInfo");
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        settings.add(new Legend("misc"));
        this.total = new SettingBoolean("showTotalExp").setValuePrefix("betterHud.value.visible");
        settings.add(this.total);
        this.lifetime = new SettingBoolean("showLifetimeExp").setValuePrefix("betterHud.value.visible");
        settings.add(this.lifetime);
    }

    @Override
    public boolean shouldRender(Event event) {
        return super.shouldRender(event) && BetterHud.MC.field_71442_b.func_78763_f();
    }

    @Override
    public Rect render(Event event) {
        int fullBar = ExperienceInfo.getExperienceWithinLevel(BetterHud.MC.field_71439_g.field_71068_ca);
        int has = (int)(BetterHud.MC.field_71439_g.field_71106_cc * (float)fullBar);
        int needed = fullBar - has;
        String hasDisplay = String.valueOf(has);
        String neededDisplay = String.valueOf(needed);
        Rect bar = EXPERIENCE.getLastBounds();
        Point text = new Rect(GlUtil.getStringSize(hasDisplay).sub(0, 2)).anchor(bar, Direction.WEST).getPosition();
        GlUtil.drawBorderedString(hasDisplay, text.getX(), text.getY(), Color.WHITE);
        text = new Rect(GlUtil.getStringSize(neededDisplay).sub(0, 2)).anchor(bar, Direction.EAST).getPosition();
        GlUtil.drawBorderedString(neededDisplay, text.getX(), text.getY(), Color.WHITE);
        return super.render(event);
    }

    private static int getExperienceWithinLevel(int level) {
        if (level >= 31) {
            return 9 * level - 158;
        }
        if (level >= 16) {
            return 5 * level - 38;
        }
        return 2 * level + 7;
    }

    private static int getExperienceToLevel(int level) {
        if (level >= 32) {
            return (int)((4.5 * (double)level - 162.5) * (double)level) + 2220;
        }
        if (level >= 17) {
            return (int)((2.5 * (double)level - 40.5) * (double)level) + 360;
        }
        return (level + 6) * level;
    }

    @Override
    protected List<String> getText() {
        ArrayList<String> parts = new ArrayList<String>(2);
        if (this.total.get().booleanValue()) {
            int totalDisplay = ExperienceInfo.getExperienceToLevel(BetterHud.MC.field_71439_g.field_71068_ca);
            totalDisplay = (int)((float)totalDisplay + BetterHud.MC.field_71439_g.field_71106_cc * (float)ExperienceInfo.getExperienceWithinLevel(BetterHud.MC.field_71439_g.field_71068_ca));
            parts.add(this.total.getLocalizedName() + ": " + totalDisplay);
        }
        if (this.lifetime.get().booleanValue()) {
            parts.add(this.lifetime.getLocalizedName() + ": " + BetterHud.MC.field_71439_g.field_71067_cb);
        }
        return parts;
    }
}

