/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element;

import java.util.List;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.HudElement;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.render.Color;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ArrowCount
extends HudElement {
    private static final ItemStack ARROW = new ItemStack(Items.field_151032_g, 1);
    private SettingBoolean overlay;

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.overlay.set(true);
        this.position.setPreset(Direction.SOUTH_EAST);
        this.settings.priority.set(1);
    }

    public ArrowCount() {
        super("arrowCount", new SettingPosition(DirectionOptions.CORNERS, DirectionOptions.NONE));
        this.position.setEnableOn(() -> this.overlay.get() == false);
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.overlay = new SettingBoolean("overlay");
        settings.add(this.overlay);
    }

    private int arrowCount(EntityPlayer player) {
        int count = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemArrow)) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    @Override
    public boolean shouldRender(Event event) {
        boolean offhandHeld;
        if (!super.shouldRender(event)) {
            return false;
        }
        ItemStack stack = BetterHud.MC.field_71439_g.func_184592_cb();
        boolean bl = offhandHeld = stack != null && stack.func_77973_b() == Items.field_151031_f;
        if (this.overlay.get().booleanValue()) {
            if (HudElement.OFFHAND.isEnabledAndSupported() && offhandHeld) {
                return true;
            }
            if (HudElement.HOTBAR.isEnabledAndSupported()) {
                for (int i = 0; i < 9; ++i) {
                    stack = BetterHud.MC.field_71439_g.field_71071_by.func_70301_a(i);
                    if (stack == null || stack.func_77973_b() != Items.field_151031_f) continue;
                    return true;
                }
            }
            return false;
        }
        if (offhandHeld) {
            return true;
        }
        stack = BetterHud.MC.field_71439_g.func_184614_ca();
        return stack != null && stack.func_77973_b() == Items.field_151031_f;
    }

    @Override
    public Rect render(Event event) {
        int totalArrows = this.arrowCount((EntityPlayer)BetterHud.MC.field_71439_g);
        if (this.overlay.get().booleanValue()) {
            Rect stackRect = new Rect(16, 16).anchor(HOTBAR.getLastBounds().grow(-3), Direction.WEST);
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = BetterHud.MC.field_71439_g.field_71071_by.func_70301_a(i);
                if (stack != null && stack.func_77973_b() == Items.field_151031_f) {
                    ArrowCount.drawCounter(stackRect, totalArrows);
                }
                stackRect = stackRect.withX(stackRect.getX() + 20);
            }
            ItemStack stack = BetterHud.MC.field_71439_g.field_71071_by.func_70301_a(40);
            if (stack != null && stack.func_77973_b() == Items.field_151031_f) {
                ArrowCount.drawCounter(new Rect(OFFHAND.getLastBounds().getPosition().add(3, 3), new Point(16, 16)), totalArrows);
            }
            return Rect.empty();
        }
        Rect bounds = this.position.applyTo(new Rect(16, 16));
        GlUtil.renderSingleItem(ARROW, bounds.getPosition());
        ArrowCount.drawCounter(bounds, totalArrows);
        return bounds;
    }

    private static void drawCounter(Rect stackRect, int count) {
        String countDisplay = String.valueOf(count);
        Rect text = new Rect(GlUtil.getStringSize(countDisplay)).align(stackRect.grow(1, 1, 1, 2).getAnchor(Direction.NORTH_EAST), Direction.NORTH_EAST);
        GlUtil.drawString(countDisplay, text.getPosition(), Direction.NORTH_WEST, Color.WHITE);
    }
}

