/*
 * Decompiled with CFR 0.152.
 */
package jobicade.betterhud.element;

import java.util.List;
import jobicade.betterhud.BetterHud;
import jobicade.betterhud.element.EquipmentDisplay;
import jobicade.betterhud.element.settings.DirectionOptions;
import jobicade.betterhud.element.settings.Setting;
import jobicade.betterhud.element.settings.SettingBoolean;
import jobicade.betterhud.element.settings.SettingChoose;
import jobicade.betterhud.element.settings.SettingPosition;
import jobicade.betterhud.geom.Direction;
import jobicade.betterhud.geom.Point;
import jobicade.betterhud.geom.Rect;
import jobicade.betterhud.geom.Size;
import jobicade.betterhud.render.DefaultBoxed;
import jobicade.betterhud.render.Grid;
import jobicade.betterhud.render.Label;
import jobicade.betterhud.util.GlUtil;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ArmorBars
extends EquipmentDisplay {
    private SettingChoose barType;
    private SettingBoolean alwaysVisible;

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.barType.setIndex(2);
        this.position.setPreset(Direction.NORTH_WEST);
        this.alwaysVisible.set(false);
    }

    public ArmorBars() {
        super("armorBars", new SettingPosition(DirectionOptions.CORNERS, DirectionOptions.WEST_EAST));
    }

    @Override
    protected void addSettings(List<Setting<?>> settings) {
        super.addSettings(settings);
        this.barType = new SettingChoose("bars", "visible.off", "smallBars", "largeBars");
        settings.add(this.barType);
        this.alwaysVisible = new SettingBoolean("alwaysVisible");
        settings.add(this.alwaysVisible);
    }

    @Override
    public boolean shouldRender(Event event) {
        if (!super.shouldRender(event)) {
            return false;
        }
        if (this.alwaysVisible.get().booleanValue()) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            if (BetterHud.MC.field_71439_g.field_71071_by.func_70440_f(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Rect render(Event event) {
        Grid<SlotDisplay> grid = new Grid(new Point(1, 4)).setStretch(true);
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = BetterHud.MC.field_71439_g.field_71071_by.func_70440_f(3 - i);
            TextureAtlasSprite empty = BetterHud.MC.func_147117_R().func_110572_b(ItemArmor.field_94603_a[3 - i]);
            grid.setCell(new Point(0, i), new SlotDisplay(stack, empty));
        }
        Rect bounds = this.position.applyTo(new Rect(grid.getPreferredSize()));
        grid.setBounds(bounds).render();
        return bounds;
    }

    private class SlotDisplay
    extends DefaultBoxed {
        private final ItemStack stack;
        private final TextureAtlasSprite empty;

        public SlotDisplay(ItemStack stack, TextureAtlasSprite empty) {
            this.stack = stack;
            this.empty = empty;
        }

        private Label getLabel() {
            return new Label(ArmorBars.this.getText(this.stack));
        }

        @Override
        public Size getPreferredSize() {
            int textBarWidth = this.getLabel().getPreferredSize().getWidth();
            if (ArmorBars.this.barType.getIndex() == 2 && ArmorBars.this.showDurability(this.stack)) {
                textBarWidth = Math.max(textBarWidth, 64);
            }
            return new Size(textBarWidth > 0 ? 20 + textBarWidth : 16, 16);
        }

        @Override
        public void render() {
            Direction contentAlignment = ArmorBars.this.position.getContentAlignment();
            Rect textBarArea = this.bounds.withWidth(this.bounds.getWidth() - 20).anchor(this.bounds, contentAlignment.mirrorCol());
            Rect item = new Rect(16, 16).anchor(this.bounds, contentAlignment);
            if (this.stack.func_190926_b()) {
                BetterHud.MC.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                BetterHud.MC.field_71456_v.func_175175_a(item.getX(), item.getY(), this.empty, item.getWidth(), item.getHeight());
                BetterHud.MC.func_110434_K().func_110577_a(Gui.field_110324_m);
            } else {
                GlUtil.renderSingleItem(this.stack, item.getPosition());
            }
            Label label = this.getLabel();
            label.setBounds(new Rect(label.getPreferredSize()).anchor(textBarArea, contentAlignment)).render();
            int barTypeIndex = ArmorBars.this.barType.getIndex();
            if (barTypeIndex != 0 && ArmorBars.this.showDurability(this.stack)) {
                Rect bar;
                if (barTypeIndex == 2) {
                    Direction barAlignment = label.getText() != null ? Direction.SOUTH : Direction.CENTER;
                    bar = textBarArea.withHeight(2).anchor(textBarArea, barAlignment);
                } else {
                    bar = item.grow(-2, -13, -1, -1);
                }
                GlUtil.drawDamageBar(bar, this.stack, false);
            }
        }
    }
}

